/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.im;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.MtzVersion;
import com.paterva.maltego.archive.mtz.MtzVersionEntry;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigComparator;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.dialog.FileController;
import java.io.File;
import java.util.TreeMap;
import javax.swing.JComponent;
import net.lingala.zip4j.core.ZipFile;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

class ImportFileController<TData>
extends FileController {
    public ImportFileController() {
        super(0, "Maltego Archive", ImportFileController.getExtensions());
    }

    private static String[] getExtensions() {
        return new String[]{"mtz", GraphFileType.GRAPHML.getExtension(), GraphFileType.PANDORA.getExtension()};
    }

    public void readSettings(WizardDescriptor settings) {
        Object icon;
        super.readSettings(settings);
        Object description = settings.getProperty("file_description");
        if (description != null) {
            this.setDescription((String)description);
        }
        if ((icon = settings.getProperty("file_icon")) != null) {
            this.setImage(ImageUtilities.loadImage((String)((String)icon).replace(".png", "48.png")));
        }
    }

    public void validate() throws WizardValidationException {
        String error;
        block13: {
            error = null;
            File file = this.getSelectedFile();
            if (file == null) {
                error = "Please choose a file name";
            } else {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    if (zipFile.isEncrypted()) {
                        String password = PasswordUtil.getPasswordInput((boolean)false);
                        if (password != null) {
                            zipFile.setPassword(password);
                            if (!PasswordUtil.isPasswordValid((ZipFile)zipFile)) {
                                error = "Unable to open the file because the password was entered incorrectly.";
                            }
                        } else {
                            error = "Password required.";
                        }
                    }
                    if (error == null) {
                        MaltegoArchiveReader reader = new MaltegoArchiveReader(zipFile);
                        MtzVersion version = (MtzVersion)reader.read((Entry)new MtzVersionEntry());
                        if (!MtzVersion.isMtzVersionSupported((MtzVersion)version)) {
                            error = "The version of the file (" + MtzVersion.getMtzVersion((MtzVersion)version) + ") is newer than what is supported (" + MtzVersion.getMtzVersion((MtzVersion)MtzVersion.getCurrent()) + "). Please update your Maltego client and try again.";
                        } else {
                            ConfigImporter[] importers = (ConfigImporter[])this.getDescriptor().getProperty("importers");
                            TreeMap<Config, ConfigImporter> configsMap = new TreeMap<Config, ConfigImporter>(new ConfigComparator());
                            for (ConfigImporter importer : importers) {
                                Config config = importer.loadConfig(reader);
                                if (config == null) continue;
                                configsMap.put(config, importer);
                            }
                            this.getDescriptor().putProperty("configsMap", configsMap);
                            this.getDescriptor().putProperty("allConfigs", (Object)new AllConfigsNode(configsMap.keySet(), true));
                        }
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    error = ex.getMessage();
                    if (!StringUtilities.isNullOrEmpty((String)error)) break block13;
                    error = "Error reading file";
                }
            }
        }
        if (error != null) {
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
    }
}

