/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui;

import com.paterva.maltego.seeds.api.HubSeedBadge;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedStatistics;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Font;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.UIDefaults;

public class HubSeedUtils {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd MMMMM yyyy");
    private static final Date MIN_DATE = new GregorianCalendar(2000, 0, 1).getTime();
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();

    public static String getTxEntityCounts(HubSeedDescriptor seed) {
        HubSeedStatistics stats;
        String text = "";
        if (seed != null && (stats = seed.getStatistics()) != null) {
            Integer txCount = stats.getTransformCount();
            Integer entityCount = stats.getEntityCount();
            Stream.Builder<String> builder = Stream.builder();
            if (txCount != null && txCount > 0) {
                builder.add(txCount + " Transforms");
            }
            if (entityCount != null && entityCount > 0) {
                builder.add(entityCount + " Entities");
            }
            text = builder.build().collect(Collectors.joining(" | "));
        }
        return text;
    }

    public static String getDateModifiedText(HubSeedDescriptor seed) {
        Date modified;
        String text = "";
        if (seed != null && (modified = seed.getModified()) != null && modified.after(MIN_DATE)) {
            text = "Last modified: " + DATE_FORMAT.format(modified);
        }
        return text;
    }

    public static HubSeedBadge getLocationBadge(HubSeedDescriptor seed, String location) {
        List badges;
        HubSeedBadge locationBadge = null;
        if (seed != null && (badges = seed.getBadges()) != null && !badges.isEmpty()) {
            for (HubSeedBadge badge : badges) {
                if (!HubSeedUtils.badgeMatchesLocation(badge, location)) continue;
                locationBadge = badge;
                break;
            }
        }
        return locationBadge;
    }

    public static Font getFontScaled(String key) {
        Font font = LAF.getFont(key);
        return font;
    }

    public static Color getBadgeFgColor(JComponent component, HubSeedBadge badge) {
        return HubSeedUtils.getBadgeColor(badge.getFgColor(), () -> component.getForeground());
    }

    public static Color getBadgeBgColor(JComponent component, HubSeedBadge badge) {
        return HubSeedUtils.getBadgeColor(badge.getBgColor(), () -> component.getParent() != null ? component.getParent().getBackground() : component.getBackground());
    }

    private static Color getBadgeColor(String code, Supplier<Color> fallback) {
        Color color;
        block4: {
            color = null;
            try {
                color = Color.decode(code);
            }
            catch (Exception ex1) {
                if (code == null || code.length() != 9) break block4;
                try {
                    Color opaque = Color.decode("0x" + code.substring(1, 7));
                    color = new Color(opaque.getRed(), opaque.getGreen(), opaque.getBlue(), Integer.parseInt(code.substring(7, 9), 16));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return Optional.ofNullable(color).orElseGet(fallback);
    }

    private static boolean badgeMatchesLocation(HubSeedBadge badge, String location) {
        return badge.getLocation() != null && badge.getLocation().equalsIgnoreCase(location);
    }
}

