/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.view2d.LabelHoverViewMode;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jdesktop.swingx.color.ColorUtil;
import yguard.A.A.Y;
import yguard.A.J.BA;
import yguard.A.J.gB;

public class NotesHoverViewMode
extends LabelHoverViewMode {
    public NotesHoverViewMode() {
        super(2);
    }

    @Override
    protected boolean showIfEntityNotHovered(GraphID graphID, EntityID entityID, MaltegoEntity entity) {
        return entity == null ? false : !StringUtilities.isNullOrEmpty((String)entity.getNotes());
    }

    @Override
    protected void onHoverChanged(Y oldNode, Y newNode) {
        Color color;
        gB nLabel;
        super.onHoverChanged(oldNode, newNode);
        if (oldNode != null && (nLabel = this.getLabel(oldNode, 4)) != null) {
            color = this.getColor("note-shadow-color", "note-shadow-alpha");
            nLabel.setLineColor(color);
            nLabel.repaint();
        }
        if (newNode != null && (nLabel = this.getLabel(newNode, 4)) != null) {
            color = this.getColor("note-shadow-hover-color", "note-shadow-hover-alpha");
            nLabel.setLineColor(color);
            nLabel.repaint();
        }
    }

    private Color getColor(String colorKey, String alphaKey) {
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        return ColorUtil.setAlpha((Color)laf.getColor(colorKey), (int)Integer.decode((String)laf.get(alphaKey)));
    }

    private gB getLabel(Y node, int index) {
        BA realizer = this.view.getGraph2D().f(node);
        if (realizer.labelCount() > index) {
            return realizer.getLabel(index);
        }
        return null;
    }
}

