/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeEditor;
import com.paterva.maltego.ui.graph.view2d.EmptyNodeMap;
import com.paterva.maltego.ui.graph.view2d.MouseWheelListenerProxy;
import com.paterva.maltego.ui.graph.view2d.PopupAwareEditMode;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import yguard.A.A.D;
import yguard.A.A.F;
import yguard.A.A.M;
import yguard.A.A.Y;
import yguard.A.J.AA;
import yguard.A.J.BA;
import yguard.A.J.u;
import yguard.A.J.wA;

class CollectionNodeEditMode
extends AA {
    private static final CollectionNodeEditor _editor = new CollectionNodeEditor();
    private Y _node;
    private ZoomChangeListener _zoomListener;
    private JComponent _editorComponent;
    private GraphID _graphID;

    public CollectionNodeEditMode(wA editMode) {
        super((u)_editor, (M)new EmptyNodeMap());
    }

    public boolean isNodeEditable(Y node) {
        EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
        return painter != null ? painter.isCollectionNodeEditorEnabled() : false;
    }

    public void setGraphID(GraphID graphID) {
        this._graphID = graphID;
        MouseWheelListenerProxy.forGraph(graphID).addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e2) {
                if (CollectionNodeEditMode.this._node != null) {
                    Component[] components = CollectionNodeEditMode.this._editorComponent.getComponents();
                    JScrollPane scrollPane = (JScrollPane)components[0];
                    JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
                    int value = verticalScrollBar.getValue();
                    int rows = 5;
                    verticalScrollBar.setValue(value += rows * 7 * e2.getWheelRotation());
                    e2.consume();
                }
            }
        });
    }

    public void mouseMoved(MouseEvent e2) {
        super.mouseMoved(e2);
        Y hitNode = this.getHitInfo(e2).V();
        if ((hitNode != this.getEditingNode() || this.view.getZoom() < 2.0 || hitNode != null && !PopupAwareEditMode.isOverCollectionNodeMinusBanner(hitNode, this.view, e2)) && !this.stopCellEditing()) {
            this.cancelEditing();
        }
    }

    protected void installEditor(JComponent component, BA nr) {
        this._editorComponent = component;
        this._node = nr.getNode();
        CollectionNodeEditMode.setEditing(this._node, true);
        this._zoomListener = new ZoomChangeListener();
        this.view.getCanvasComponent().addPropertyChangeListener(this._zoomListener);
        super.installEditor(component, nr);
    }

    protected void removeEditor() {
        super.removeEditor();
        this.view.getCanvasComponent().removePropertyChangeListener(this._zoomListener);
        this._zoomListener = null;
        CollectionNodeEditMode.setEditing(this._node, false);
        this._node = null;
        this._editorComponent = null;
    }

    private static void setEditing(Y node, boolean editing) {
        D graph;
        if (node != null && (graph = node.H()) != null) {
            ((F)graph.B((Object)"IS_EDITING_DPKEY")).setBool((Object)node, editing);
        }
    }

    private class ZoomChangeListener
    implements PropertyChangeListener {
        private ZoomChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("Zoom".equals(evt.getPropertyName()) && CollectionNodeEditMode.this.view.getZoom() < 2.0 && !CollectionNodeEditMode.this.stopCellEditing()) {
                CollectionNodeEditMode.this.cancelEditing();
            }
        }
    }
}

