/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.Java2DOptions;
import com.paterva.maltego.java.config.Java2DProperty;
import com.paterva.maltego.java.config.Java2DSettings;
import com.paterva.maltego.java.config.MatteBorderLeft;
import com.paterva.maltego.java.config.jre.SystemUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;

public class Java2DPanel
extends JPanel {
    private final AtomicBoolean _allowComboActions = new AtomicBoolean(true);
    private final AtomicBoolean _updating = new AtomicBoolean(false);
    private Java2DOptions _comboSelectedItem = null;
    private ChangeListener _changeListener;
    private ButtonGroup _addressesGroup;
    private JComboBox _renderingComboBox;
    private JLabel _restartLabel;
    private ButtonGroup _stackGroup;

    public Java2DPanel() {
        Java2DOptions[] java2DOptionsArray;
        this.initComponents();
        this._allowComboActions.set(false);
        this._renderingComboBox.setEditable(false);
        if (SystemUtils.isWindows2()) {
            java2DOptionsArray = Java2DOptions.values();
        } else {
            Java2DOptions[] java2DOptionsArray2 = new Java2DOptions[2];
            java2DOptionsArray2[0] = Java2DOptions.OPENGL;
            java2DOptionsArray = java2DOptionsArray2;
            java2DOptionsArray2[1] = Java2DOptions.SOFTWARE;
        }
        this._renderingComboBox.setModel(new DefaultComboBoxModel<Java2DOptions>(java2DOptionsArray));
        this._renderingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (!Java2DPanel.this._updating.get()) {
                    Java2DPanel.this.comboItemStateChanged(evt);
                }
            }
        });
        this._renderingComboBox.setSelectedIndex(-1);
        if (this._comboSelectedItem == null) {
            this._comboSelectedItem = this.getJava2DOption(Java2DProperty.getOpenGL().isPrefer(), Java2DProperty.getD3D().isPrefer());
        }
        this._renderingComboBox.setSelectedItem((Object)this._comboSelectedItem);
        this._allowComboActions.set(true);
    }

    public void load(ConfigOptions options) {
        this._updating.set(true);
        Java2DSettings java2DSettings = options.getJava2DSettings();
        boolean openGL = java2DSettings.getOpenGL().isPrefer();
        boolean d3d = java2DSettings.getD3D().isPrefer();
        this._comboSelectedItem = this.getJava2DOption(openGL, d3d);
        if (this._comboSelectedItem == null) {
            this._renderingComboBox.setSelectedIndex(-1);
        } else {
            this._renderingComboBox.setSelectedItem((Object)this._comboSelectedItem);
        }
        this._updating.set(false);
    }

    private Java2DOptions getJava2DOption(boolean openGL, boolean d3d) {
        Java2DOptions option = !openGL && !d3d ? Java2DOptions.SOFTWARE : (openGL && !d3d ? Java2DOptions.OPENGL : (!openGL && d3d && SystemUtils.isWindows2() ? Java2DOptions.D3D : null));
        return option;
    }

    public void store(ConfigOptions options) {
        options.setJava2DSettings(this.getJava2DSettings(true));
    }

    public Java2DSettings getJava2DSettings(boolean preferred) {
        Java2DProperty openGL = Java2DProperty.getOpenGL();
        openGL.setPrefer(this.isOpenGLSelected());
        Java2DProperty d3d = Java2DProperty.getD3D();
        d3d.setPrefer(this.isD3DSelected());
        Java2DSettings java2DSettings = new Java2DSettings(openGL, d3d);
        return this._comboSelectedItem == null && !preferred ? null : java2DSettings;
    }

    public boolean valid() {
        return true;
    }

    boolean isOpenGLSelected() {
        if (this._comboSelectedItem != null) {
            switch (this._comboSelectedItem) {
                case SOFTWARE: {
                    return false;
                }
                case OPENGL: {
                    return true;
                }
                case D3D: {
                    return false;
                }
            }
        }
        return Java2DProperty.getOpenGL().isPrefer();
    }

    boolean isD3DSelected() {
        if (this._comboSelectedItem != null) {
            switch (this._comboSelectedItem) {
                case SOFTWARE: {
                    return false;
                }
                case OPENGL: {
                    return false;
                }
                case D3D: {
                    return SystemUtils.isWindows2();
                }
            }
        }
        return Java2DProperty.getD3D().isPrefer();
    }

    void setSelectedTest(Java2DOptions option) {
        this.comboItemStateChanged(new ItemEvent(this._renderingComboBox, 0, (Object)option, 1));
    }

    void setChangeListener(ChangeListener listener) {
        this._changeListener = listener;
    }

    private void comboItemStateChanged(ItemEvent evt) {
        if (this._allowComboActions.get() && evt.getStateChange() == 1) {
            Java2DOptions itemName;
            this._comboSelectedItem = itemName = (Java2DOptions)((Object)evt.getItem());
            if (this._changeListener != null) {
                this._changeListener.stateChanged(null);
            }
        }
    }

    private void initComponents() {
        this._stackGroup = new ButtonGroup();
        this._addressesGroup = new ButtonGroup();
        JLabel _renderingLabel = new JLabel();
        this._renderingComboBox = new JComboBox();
        this._restartLabel = new JLabel();
        JPanel jPanel4 = new JPanel();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), "Java 2D Properties"), BorderFactory.createEmptyBorder(3, 10, 3, 10)));
        this.setLayout(new GridBagLayout());
        _renderingLabel.setText("Rendering");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 9, 0, 3);
        this.add((Component)_renderingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 30;
        this.add((Component)this._renderingComboBox, gridBagConstraints);
        this._restartLabel.setFont(this._restartLabel.getFont().deriveFont((float)this._restartLabel.getFont().getSize() - 1.0f));
        this._restartLabel.setText("(Requires restart)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add((Component)this._restartLabel, gridBagConstraints);
        jPanel4.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel4, gridBagConstraints);
    }
}

