/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.io.EntityDetector;
import com.paterva.maltego.graph.table.io.TableHeaders;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraph;
import com.paterva.maltego.graph.table.io.links.ConnectivityOptions;
import com.paterva.maltego.graph.table.io.links.LinkConnector;
import com.paterva.maltego.transform.gen.TransformSourceRegistry;
import com.paterva.maltego.transforms.tabular.TabularTransformFactory;
import com.paterva.maltego.transforms.tabular.data.TabularTransform;
import com.paterva.maltego.transforms.tabular.data.TabularTransformEntityNames;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.transforms.tabular.ui.TabularTransformSourceCreator;
import com.paterva.maltego.util.Args;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class DefaultTabularTransformSourceCreator
extends TabularTransformSourceCreator {
    @Override
    public TabularTransformSource create(File file) throws Exception {
        Args.notNull((Object)file, (String)"file");
        DefaultTabularGraph tabularGraph = new DefaultTabularGraph();
        return this.create((TabularGraph)tabularGraph, Collections.singletonList(file.getPath()));
    }

    @Override
    public TabularTransformSource create(TabularGraph tabularGraph, List<String> files) throws Exception {
        String fileNoExtension;
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        Args.notNull(files, (String)"files");
        File firstFile = files.stream().map(File::new).findFirst().orElseThrow(() -> new IllegalArgumentException("files may not be empty"));
        String displayName = fileNoExtension = this.toDisplayName(firstFile);
        String name = DefaultTabularTransformSourceCreator.toName(displayName);
        int postfix = 1;
        while (TransformSourceRegistry.getInstance().get(name).isPresent()) {
            displayName = fileNoExtension + ++postfix;
            name = DefaultTabularTransformSourceCreator.toName(displayName);
        }
        tabularGraph.setName(name);
        return this.create(tabularGraph, name, displayName, files, false);
    }

    @Override
    public TabularTransformSource recreate(TabularTransformSource txSource, TabularGraph tabularGraph, boolean resetLinks) throws Exception {
        Args.notNull((Object)txSource, (String)"txSource");
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        String tabularGraphName = txSource.getTabularGraphName();
        MappingRegistry.getDefault().remove(tabularGraphName);
        if (resetLinks) {
            LinkConnector linkConnector = new LinkConnector();
            linkConnector.createLinks(tabularGraph, ConnectivityOptions.SEQUENTIAL_TREE);
        }
        return this.createForEntitiesAndLinks(tabularGraph, txSource.getName(), txSource.getDisplayName(), txSource.getSourceFiles(), txSource.getEntityNames(), txSource.isSearchFavorited());
    }

    private String toDisplayName(File file) {
        Args.notNull((Object)file, (String)"file");
        return file.getName().replaceFirst("^([^.]+).*$", "$1");
    }

    private static String toName(String displayName) {
        Args.notNullOrBlank((String)displayName, (String)"displayName");
        return displayName.replaceAll("[^\\w]", "");
    }

    private TabularTransformSource create(TabularGraph tabularGraph, String name, String displayName, List<String> files, boolean searchFavorited) throws IOException {
        Args.notNull((Object)tabularGraph, (String)"tabularGraph");
        Args.notNullOrBlank((String)name, (String)"name");
        Args.notNullOrBlank((String)displayName, (String)"displayName");
        Args.notNullOrEmpty(files, (String)"files");
        String firstFile = files.get(0);
        EntityDetector.getInstance().detectEntities(tabularGraph, new File(firstFile));
        LinkConnector linkConnector = new LinkConnector();
        linkConnector.createLinks(tabularGraph, ConnectivityOptions.SEQUENTIAL_TREE);
        TabularTransformEntityNames entityNames = this.createEntityNames(tabularGraph, firstFile);
        return this.createForEntitiesAndLinks(tabularGraph, name, displayName, files, entityNames, searchFavorited);
    }

    private TabularTransformEntityNames createEntityNames(TabularGraph tabularGraph, String sourceFile) {
        Args.notNullOrBlank((String)sourceFile, (String)"sourceFile");
        HashMap<Integer, String> entityNames = new HashMap<Integer, String>();
        TableHeaders headers = new TableHeaders(tabularGraph, sourceFile);
        for (TabularGraphEntity entity : tabularGraph.getEntities()) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)EntityRegistry.getDefault().get(entity.getEntitySpecName());
            String specDisplayName = spec == null ? entity.getEntitySpecName() : spec.getDisplayName();
            String entityNameStr = headers.getHeaderDisplayName(entity).orElse(specDisplayName);
            entityNames.put(entity.getColumns()[0], entityNameStr);
        }
        return new TabularTransformEntityNames(entityNames);
    }

    private TabularTransformSource createForEntitiesAndLinks(TabularGraph tabularGraph, String name, String displayName, List<String> files, TabularTransformEntityNames entityNames, boolean searchFavorited) throws IOException {
        List<TabularTransform> tabularTxs = this.generateTransforms(tabularGraph, displayName, entityNames);
        tabularGraph.setSavedDate(new Date());
        MappingRegistry.getDefault().put(tabularGraph);
        return new TabularTransformSource(name, displayName, name, files, tabularTxs, entityNames, searchFavorited);
    }

    private List<TabularTransform> generateTransforms(TabularGraph tabularGraph, String displayName, TabularTransformEntityNames names) throws IOException {
        TabularTransformFactory factory = new TabularTransformFactory(tabularGraph, names);
        return factory.generateTabularTransforms();
    }
}

