/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.ClipboardGraphID;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.Version;
import java.io.File;
import org.openide.modules.Places;

public class GraphStoreCache {
    private static final String CACHE_DIR_NAME = "GraphStores";
    private static File _cacheDir;
    private static File _clipboardDir;

    public static synchronized File get() {
        if (_cacheDir == null) {
            _cacheDir = Places.getCacheSubdirectory((String)CACHE_DIR_NAME);
        }
        return _cacheDir;
    }

    public static synchronized File getClipboard() {
        if (_clipboardDir == null) {
            String tempDir = System.getProperty("java.io.tmpdir");
            _clipboardDir = new File(tempDir, Version.getCurrent().getAppnameCapital() + "Clipboard");
        }
        return _clipboardDir;
    }

    public static File get(GraphID graphID) {
        File file = ClipboardGraphID.get().equals((Object)graphID) ? GraphStoreCache.getClipboard() : new File(GraphStoreCache.get(), graphID.toString());
        return file;
    }

    public static synchronized void clear(GraphID graphID) {
        FileUtilities.delete((File)GraphStoreCache.get(graphID));
    }

    public static synchronized void clear() {
        FileUtilities.delete((File)GraphStoreCache.get());
    }
}

