/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.serializers.compact;

import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.compact.IconCollection;
import com.paterva.maltego.serializers.compact.stubs.IconCategoryStub;
import com.paterva.maltego.serializers.compact.stubs.IconImageStub;
import com.paterva.maltego.serializers.compact.stubs.IconStub;
import com.paterva.maltego.serializers.compact.stubs.IconsStub;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.simpleframework.xml.core.Persister;

public class IconsSerializer {
    public String toString(IconCollection icons) throws GraphSerializationException {
        if (icons == null || icons.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                this.write(icons, (OutputStream)bos);
            }
            finally {
                bos.close();
            }
        }
        catch (IOException ex) {
            throw new GraphSerializationException(ex, true);
        }
        return bos.toString();
    }

    public void write(IconCollection icons, OutputStream os) throws GraphSerializationException {
        try {
            IconsStub stub = this.translate(icons);
            Persister serializer = new Persister();
            serializer.write((Object)stub, os);
        }
        catch (Exception ex) {
            throw new GraphSerializationException(ex, true);
        }
    }

    private IconsStub translate(IconCollection icons) throws IOException {
        IconsStub iconsStub = new IconsStub();
        for (Map.Entry entry : icons.entrySet()) {
            String iconCategory = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            if (StringUtilities.isNullOrEmpty((String)iconCategory)) {
                iconCategory = "UnknownIconCategory";
            }
            IconCategoryStub iconCategoryStub = new IconCategoryStub(iconCategory);
            for (Map.Entry nameEntry : value.entrySet()) {
                IconStub iconStub = new IconStub((String)nameEntry.getKey());
                IconCollection.Icon icon = (IconCollection.Icon)nameEntry.getValue();
                for (Map.Entry<IconSize, Image> sizeEntry : icon.getImages().entrySet()) {
                    IconSize size = sizeEntry.getKey();
                    Image image = sizeEntry.getValue();
                    String base64Image = ImageUtils.base64Encode((Image)image, (String)"png");
                    iconStub.add(new IconImageStub(size.getSize(), base64Image));
                }
                iconStub.setAliases(icon.getAliases());
                iconCategoryStub.add(iconStub);
            }
            iconsStub.add(iconCategoryStub);
        }
        return iconsStub;
    }

    public IconCollection read(String xml) throws GraphSerializationException {
        Persister serializer = new Persister();
        IconCollection icons = new IconCollection();
        try {
            IconsStub iconsStub = (IconsStub)serializer.read(IconsStub.class, xml);
            for (IconCategoryStub iconCategoryStub : iconsStub.getCategories()) {
                HashMap<String, IconCollection.Icon> iconsByName = new HashMap<String, IconCollection.Icon>();
                EnumMap<IconSize, Image> iconImages = new EnumMap<IconSize, Image>(IconSize.class);
                for (IconStub iconStub : iconCategoryStub.getIcons()) {
                    for (IconImageStub iconImageStub : iconStub.getIconImages()) {
                        IconSize size = IconSize.getSize((int)iconImageStub.getSize());
                        BufferedImage image = ImageUtils.base64Decode((String)iconImageStub.getBase64Image());
                        iconImages.put(size, image);
                    }
                    IconCollection.Icon icon = new IconCollection.Icon(iconImages, iconStub.getAliases());
                    iconsByName.put(iconStub.getName(), icon);
                }
                icons.put(iconCategoryStub.getName(), iconsByName);
            }
        }
        catch (Exception ex) {
            throw new GraphSerializationException(ex, true);
        }
        return icons;
    }
}

