/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.TargetMappingNode;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToHostNode.class)
final class ToHostNodeGen
extends ToHostNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private CachedData cached_cache;

    private ToHostNodeGen() {
    }

    @Override
    @ExplodeLoop
    public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (s1_.interop_.accepts(arg0Value) && arg1Value == s1_.cachedTargetType_) {
                        return this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_, s1_.error_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (!(s1_ == null || s1_.interop_.accepts(arg0Value) && arg1Value == s1_.cachedTargetType_)) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 5) {
                    s1_ = super.insert(new CachedData(this.cached_cache));
                    s1_.interop_ = s1_.insertAccessor(INTEROP_LIBRARY_.create(arg0Value));
                    s1_.cachedTargetType_ = arg1Value;
                    s1_.primitiveTarget_ = ToHostNode.isPrimitiveTarget(s1_.cachedTargetType_);
                    s1_.allowsImplementation_ = ToHostNode.allowsImplementation(arg3Value, arg1Value);
                    s1_.targetMapping_ = s1_.insertAccessor(TargetMappingNode.create());
                    s1_.error_ = BranchProfile.create();
                    this.cached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, s1_.interop_, s1_.cachedTargetType_, s1_.primitiveTarget_, s1_.allowsImplementation_, s1_.targetMapping_, s1_.error_);
                    return object;
                }
            }
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            Object object = ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToHostNode create() {
        return new ToHostNodeGen();
    }

    public static ToHostNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToHostNode.class)
    private static final class Uncached
    extends ToHostNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0Value, Class<?> arg1Value, Type arg2Value, PolyglotLanguageContext arg3Value, boolean arg4Value) {
            return ToHostNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ToHostNode.class)
    private static final class CachedData
    extends Node {
        @Node.Child
        CachedData next_;
        @Node.Child
        InteropLibrary interop_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedTargetType_;
        @CompilerDirectives.CompilationFinal
        boolean primitiveTarget_;
        @CompilerDirectives.CompilationFinal
        boolean allowsImplementation_;
        @Node.Child
        TargetMappingNode targetMapping_;
        @CompilerDirectives.CompilationFinal
        BranchProfile error_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }
    }
}

