/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.progress;

import com.paterva.maltego.automation.MachineDescriptor;
import com.paterva.maltego.automation.MachineManager;
import com.paterva.maltego.automation.MachineProgressMonitor;
import com.paterva.maltego.automation.MachineRuntimeEvent;
import com.paterva.maltego.automation.MachineRuntimeListener;
import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.automation.RuntimeState;
import com.paterva.maltego.automation.view.progress.MachineRuntimeView;
import com.paterva.maltego.automation.view.progress.MachineRuntimeViewPanel;
import com.paterva.maltego.automation.view.progress.RuntimeViewTopComponent;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DefaultMachineProgressMonitor
extends MachineProgressMonitor
implements MachineRuntimeListener,
PropertyChangeListener,
ActionListener {
    private Map<DataObject, MachineRuntimeView> _controls;
    private RuntimeViewTopComponent _topComponent;

    @Override
    public void start() {
        MachineManager.getDefault().addMachineListener(this);
        GraphEditorRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void stop() {
        MachineManager.getDefault().removeMachineListener(this);
        GraphEditorRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
    }

    private void machineStarted(MachineRuntimeEvent event) {
        RuntimeViewTopComponent view = this.getView();
        MachineRuntimeView component = this.popComponent(event.getTarget());
        if (component != null) {
            component.removeActionListener(this);
            view.remove((Component)((Object)component));
        }
        component = this.pushComponent(event.getMachine(), event.getPayload(), event.getTarget());
        view.add((Component)((Object)component), event.getTarget().toString());
        view.show(event.getTarget().toString());
        view.open();
        view.requestActive();
    }

    private RuntimeViewTopComponent getView() {
        if (this._topComponent == null) {
            TopComponent window = WindowManager.getDefault().findTopComponent("RuntimeViewTopComponent");
            this._topComponent = window != null && window instanceof RuntimeViewTopComponent ? (RuntimeViewTopComponent)window : new RuntimeViewTopComponent();
        }
        return this._topComponent;
    }

    @Override
    public void machineProgress(MachineRuntimeEvent event) {
        MachineRuntimeView component = this.getComponent(event.getTarget());
        if (component == null || event.getState() == RuntimeState.Running && this.isStopped(component.getState())) {
            this.machineStarted(event);
        } else {
            if (event.getPercent() >= 0) {
                component.setPercentComplete(event.getPercent());
            }
            component.setState(event.getState());
            if (event.getMessage() != null) {
                component.setProgessMessage(event.getMessage());
            }
            if (event.getTick() >= 0) {
                component.setTimeToNextRun(event.getTick());
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("topmost".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)evt.getNewValue();
            this.graphChanged(this.getGraph(tc));
        } else if ("tcOpened".equals(evt.getPropertyName()) && evt.getNewValue() instanceof RuntimeViewTopComponent) {
            this._topComponent = (RuntimeViewTopComponent)((Object)evt.getNewValue());
            for (Map.Entry<DataObject, MachineRuntimeView> entry : this.getControls().entrySet()) {
                MachineRuntimeView view = entry.getValue();
                this.add(this._topComponent, view, entry.getKey().toString());
                TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
                if (topmost == null) continue;
                this.graphChanged(this.getGraph(topmost));
            }
        }
    }

    private void add(RuntimeViewTopComponent tc, MachineRuntimeView view, String name) {
        for (Component component : tc.getComponents()) {
            if (!component.equals(view)) continue;
            return;
        }
        tc.add((Component)((Object)view), name);
    }

    private void graphChanged(DataObject target) {
        MachineRuntimeView component;
        String viewName = "no-machine";
        if (target != null && (component = this.getComponent(target)) != null) {
            viewName = target.toString();
        }
        this.showView(viewName);
    }

    private DataObject getGraph(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        return (DataObject)tc.getLookup().lookup(DataObject.class);
    }

    private MachineRuntimeView popComponent(DataObject target) {
        if (this._controls == null) {
            return null;
        }
        return this._controls.remove(target);
    }

    MachineRuntimeView getComponent(DataObject target) {
        if (this._controls == null) {
            return null;
        }
        return this._controls.get(target);
    }

    private MachineRuntimeView pushComponent(MachineDescriptor machine, Payload payload, DataObject target) {
        MachineRuntimeView component = this.createComponent(machine, payload, target);
        this.getControls().put(target, component);
        return component;
    }

    private Map<DataObject, MachineRuntimeView> getControls() {
        if (this._controls == null) {
            this._controls = new HashMap<DataObject, MachineRuntimeView>();
        }
        return this._controls;
    }

    private MachineRuntimeView createComponent(MachineDescriptor machine, Payload payload, DataObject target) {
        MachineRuntimeViewPanel view = new MachineRuntimeViewPanel();
        view.setTitle(machine.getDisplayName());
        view.setSubtitle(String.format("[%s]", this.payloadToString(payload, target)));
        view.setUserObject(new Object[]{machine, target});
        view.addActionListener(this);
        return view;
    }

    private void showView(String viewName) {
        RuntimeViewTopComponent view = this.getView();
        view.show(viewName);
    }

    private String payloadToString(Payload payload, DataObject target) {
        if (payload.isEmpty()) {
            return "EMPTY";
        }
        EntityRegistry registry = this.getEntityRegistry(target);
        StringBuilder buffer = new StringBuilder();
        for (MaltegoEntity e : payload.getEntities()) {
            buffer.append(InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)e));
            buffer.append(", ");
        }
        if (buffer.length() > 2) {
            return buffer.substring(0, buffer.length() - 2);
        }
        return "EMPTY";
    }

    private EntityRegistry getEntityRegistry(DataObject dao) {
        GraphID graphID;
        EntityRegistry registry = null;
        GraphCookie cookie = (GraphCookie)dao.getLookup().lookup(GraphCookie.class);
        if (cookie != null && (graphID = cookie.getGraphID()) != null) {
            registry = EntityRegistry.forGraphID((GraphID)graphID);
        }
        if (registry == null) {
            registry = EntityRegistry.getDefault();
        }
        return registry;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MachineRuntimeView view = (MachineRuntimeView)e.getSource();
        Object[] data = (Object[])view.getUserObject();
        MachineDescriptor machine = (MachineDescriptor)data[0];
        DataObject target = (DataObject)data[1];
        if ("stop".equals(e.getActionCommand())) {
            MachineManager.getDefault().stop(target, machine);
        } else if ("pause".equals(e.getActionCommand())) {
            MachineManager.getDefault().suspend(target, machine);
        } else if ("play".equals(e.getActionCommand())) {
            MachineManager.getDefault().resume(target, machine);
        }
    }

    private boolean isStopped(RuntimeState state) {
        return state == RuntimeState.Cancelled || state == RuntimeState.Completed || state == RuntimeState.Failed;
    }
}

