/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.imex;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveWriter;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.pws.api.PublicWebService;
import com.paterva.maltego.pws.api.PublicWebServices;
import com.paterva.maltego.pws.imex.SelectableService;
import com.paterva.maltego.pws.imex.SelectableServiceType;
import com.paterva.maltego.pws.imex.ServiceConfig;
import com.paterva.maltego.pws.imex.ServiceEntry;
import com.paterva.maltego.pws.imex.ServiceWrapper;
import com.paterva.maltego.pws.imex.Util;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ServicesExporter
extends ConfigExporter {
    public Config getCurrentConfig() {
        PublicWebServices registry = PublicWebServices.getDefault();
        Set types = registry.getServiceTypes();
        HashMap<String, Set<PublicWebService>> servicesPerServiceType = new HashMap<String, Set<PublicWebService>>();
        for (String type : types) {
            servicesPerServiceType.put(type, registry.getAll(type));
        }
        if (!servicesPerServiceType.isEmpty()) {
            return new ServiceConfig(Util.createSelectables(servicesPerServiceType));
        }
        return null;
    }

    public int saveConfig(MaltegoArchiveWriter writer, Config config) throws IOException {
        ServiceConfig serviceConfig = (ServiceConfig)config;
        ArrayList<String> names = new ArrayList<String>();
        for (SelectableServiceType servicetype : serviceConfig.getSelectedServiceTypes()) {
            String serviceType = servicetype.getServiceType();
            for (SelectableService selectable : servicetype) {
                if (!selectable.isSelected()) continue;
                PublicWebService service = selectable.getService();
                String fileName = this.getFileName(service, names);
                writer.write((Entry)new ServiceEntry(new ServiceWrapper(serviceType, fileName, service)));
            }
        }
        return names.size();
    }

    private String getFileName(PublicWebService service, List<String> names) {
        String name = service.getName();
        String fileName = FileUtilities.replaceIllegalChars((String)name);
        fileName = StringUtilities.createUniqueString(names, (String)fileName);
        names.add(fileName);
        return fileName;
    }
}

