/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.annotation.Experimental;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigMessages;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ConfigValueConverter;
import io.smallrye.config.ConfigurableConfigSource;
import io.smallrye.config.Converters;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigSourceInterceptorContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    public static final String SMALLRYE_CONFIG_PROFILE = "smallrye.config.profile";
    public static final String SMALLRYE_CONFIG_PROFILE_PARENT = "smallrye.config.profile.parent";
    public static final String SMALLRYE_CONFIG_LOCATIONS = "smallrye.config.locations";
    public static final String SMALLRYE_CONFIG_MAPPING_VALIDATE_UNKNOWN = "smallrye.config.mapping.validate-unknown";
    private static final long serialVersionUID = 8138651532357898263L;
    private final ConfigSources configSources;
    private final Map<Type, Converter<?>> converters;
    private final Map<Type, Converter<Optional<?>>> optionalConverters = new ConcurrentHashMap();
    private final ConfigMappings mappings;

    SmallRyeConfig(SmallRyeConfigBuilder builder, ConfigMappings mappings) {
        this.configSources = new ConfigSources(this.buildConfigSources(builder), this.buildInterceptors(builder));
        this.converters = this.buildConverters(builder);
        this.mappings = mappings;
    }

    private List<ConfigSource> buildConfigSources(SmallRyeConfigBuilder builder) {
        ArrayList<ConfigSource> sourcesToBuild = new ArrayList<ConfigSource>(builder.getSources());
        if (builder.isAddDiscoveredSources()) {
            sourcesToBuild.addAll(builder.discoverSources());
        }
        if (builder.isAddDefaultSources()) {
            sourcesToBuild.addAll(builder.getDefaultSources());
        }
        sourcesToBuild.add((ConfigSource)new DefaultValuesConfigSource(builder.getDefaultValues()));
        return sourcesToBuild;
    }

    private List<SmallRyeConfigBuilder.InterceptorWithPriority> buildInterceptors(SmallRyeConfigBuilder builder) {
        ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors = new ArrayList<SmallRyeConfigBuilder.InterceptorWithPriority>(builder.getInterceptors());
        if (builder.isAddDiscoveredInterceptors()) {
            interceptors.addAll(builder.discoverInterceptors());
        }
        if (builder.isAddDefaultInterceptors()) {
            interceptors.addAll(builder.getDefaultInterceptors());
        }
        return interceptors;
    }

    private Map<Type, Converter<?>> buildConverters(SmallRyeConfigBuilder builder) {
        HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority> convertersToBuild = new HashMap<Type, SmallRyeConfigBuilder.ConverterWithPriority>(builder.getConverters());
        if (builder.isAddDiscoveredConverters()) {
            for (Converter<?> converter : builder.discoverConverters()) {
                Type type = Converters.getConverterType(converter.getClass());
                if (type == null) {
                    throw ConfigMessages.msg.unableToAddConverter(converter);
                }
                SmallRyeConfigBuilder.addConverter(type, converter, convertersToBuild);
            }
        }
        ConcurrentHashMap converters = new ConcurrentHashMap(Converters.ALL_CONVERTERS);
        for (Map.Entry entry : convertersToBuild.entrySet()) {
            converters.put((Type)entry.getKey(), ((SmallRyeConfigBuilder.ConverterWithPriority)entry.getValue()).getConverter());
        }
        converters.put((Type)((Object)ConfigValue.class), ConfigValueConverter.CONFIG_VALUE_CONVERTER);
        return converters;
    }

    public <T> List<T> getValues(String propertyName, Class<T> propertyType) {
        return this.getValues(propertyName, propertyType, ArrayList::new);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getValues(name, this.requireConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> C getValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        try {
            return (C)((Collection)this.getValue(name, Converters.newCollectionConverter(converter, collectionFactory)));
        }
        catch (NoSuchElementException e) {
            return this.getIndexedValues(name, converter, collectionFactory);
        }
    }

    public <T, C extends Collection<T>> C getIndexedValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
        }
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            collection.add(this.getValue(indexedProperty, converter));
        }
        return (C)collection;
    }

    public List<String> getIndexedProperties(String property) {
        List<Integer> indexes = this.getIndexedPropertiesIndexes(property);
        ArrayList<String> indexedProperties = new ArrayList<String>();
        for (Integer index : indexes) {
            indexedProperties.add(property + "[" + index + "]");
        }
        return indexedProperties;
    }

    public List<Integer> getIndexedPropertiesIndexes(String property) {
        HashSet<Integer> indexes = new HashSet<Integer>();
        block2: for (String propertyName : this.getPropertyNames()) {
            int index;
            if (!propertyName.startsWith(property) || propertyName.length() <= property.length() || propertyName.charAt(index = property.length()) != '[') continue;
            while (true) {
                if (propertyName.charAt(index) == ']') {
                    try {
                        indexes.add(Integer.parseInt(propertyName.substring(property.length() + 1, index)));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue block2;
                }
                if (index >= propertyName.length() - 1) continue block2;
                ++index;
            }
        }
        ArrayList<Integer> sortIndexes = new ArrayList<Integer>(indexes);
        Collections.sort(sortIndexes);
        return sortIndexes;
    }

    public <T> T getValue(String name, Class<T> aClass) {
        return this.getValue(name, this.requireConverter(aClass));
    }

    public <T> T getValue(String name, Converter<T> converter) {
        ConfigValue configValue = this.getConfigValue(name);
        if (ConfigValueConverter.CONFIG_VALUE_CONVERTER.equals(converter)) {
            return (T)configValue;
        }
        if (converter instanceof Converters.OptionalConverter && ConfigValueConverter.CONFIG_VALUE_CONVERTER.equals((Object)((Converters.OptionalConverter)converter).getDelegate())) {
            return (T)Optional.of(configValue);
        }
        String value = configValue.getValue();
        return this.convertValue(name, value, converter);
    }

    public <T> T convertValue(String name, String value, Converter<T> converter) {
        Object converted;
        if (value != null) {
            try {
                converted = converter.convert(value);
            }
            catch (IllegalArgumentException e) {
                throw ConfigMessages.msg.converterException(e, name, value, e.getLocalizedMessage());
            }
        }
        try {
            converted = converter.convert("");
        }
        catch (IllegalArgumentException ignored) {
            throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
        }
        if (converted == null) {
            if (value == null) {
                throw new NoSuchElementException(ConfigMessages.msg.propertyNotFound(name));
            }
            if (value.length() == 0) {
                throw ConfigMessages.msg.propertyEmptyString(name, converter.getClass().getTypeName());
            }
            throw ConfigMessages.msg.converterReturnedNull(name, value, converter.getClass().getTypeName());
        }
        return (T)converted;
    }

    public boolean rawValueEquals(String name, String expected) {
        return Objects.equals(expected, this.getRawValue(name));
    }

    @Experimental(value="Extension to the original ConfigSource to allow retrieval of additional metadata on config lookup")
    public ConfigValue getConfigValue(String name) {
        ConfigValue configValue = this.configSources.getInterceptorChain().proceed(name);
        return configValue != null ? configValue : ConfigValue.builder().withName(name).build();
    }

    public String getRawValue(String name) {
        ConfigValue configValue = this.getConfigValue(name);
        return configValue != null && configValue.getValue() != null ? configValue.getValue() : null;
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        return this.getValue(name, this.getOptionalConverter(aClass));
    }

    public <T> Optional<T> getOptionalValue(String name, Converter<T> converter) {
        return this.getValue(name, Converters.newOptionalConverter(converter));
    }

    public <T> Optional<List<T>> getOptionalValues(String propertyName, Class<T> propertyType) {
        return this.getOptionalValues(propertyName, propertyType, ArrayList::new);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        return this.getOptionalValues(name, this.requireConverter(itemClass), collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        Optional<C> optionalValue = this.getOptionalValue(name, Converters.newCollectionConverter(converter, collectionFactory));
        if (optionalValue.isPresent()) {
            return optionalValue;
        }
        return this.getIndexedOptionalValues(name, converter, collectionFactory);
    }

    public <T, C extends Collection<T>> Optional<C> getIndexedOptionalValues(String name, Converter<T> converter, IntFunction<C> collectionFactory) {
        List<String> indexedProperties = this.getIndexedProperties(name);
        if (indexedProperties.isEmpty()) {
            return Optional.empty();
        }
        Collection collection = (Collection)collectionFactory.apply(indexedProperties.size());
        for (String indexedProperty : indexedProperties) {
            Optional<Object> optionalValue = this.getOptionalValue(indexedProperty, converter);
            optionalValue.ifPresent(collection::add);
        }
        if (!collection.isEmpty()) {
            return Optional.of(collection);
        }
        return Optional.empty();
    }

    public ConfigMappings getConfigMappings() {
        return this.mappings;
    }

    @Experimental(value="ConfigMapping API to group configuration properties")
    public <T> T getConfigMapping(Class<T> type) {
        return this.mappings.getConfigMapping(type);
    }

    @Experimental(value="ConfigMapping API to group configuration properties")
    public <T> T getConfigMapping(Class<T> type, String prefix) {
        return this.mappings.getConfigMapping(type, prefix);
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = this.configSources.getInterceptorChain().iterateNames();
        while (namesIterator.hasNext()) {
            names.add(namesIterator.next());
        }
        return names;
    }

    @Experimental(value="Check if a property is present")
    public boolean isPropertyPresent(String name) {
        return Expressions.withoutExpansion(() -> this.getConfigValue(name).getValue() != null);
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSources.getSources();
    }

    public <T> T convert(String value, Class<T> asType) {
        return (T)(value != null ? this.requireConverter(asType).convert(value) : null);
    }

    private <T> Converter<Optional<T>> getOptionalConverter(Class<T> asType) {
        return this.optionalConverters.computeIfAbsent(asType, clazz -> Converters.newOptionalConverter(this.requireConverter((Class)clazz)));
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> asType) {
        return Optional.ofNullable(this.getConverterOrNull(asType));
    }

    public <T> Converter<T> requireConverter(Class<T> asType) {
        Converter<T> conv = this.getConverterOrNull(asType);
        if (conv == null) {
            throw ConfigMessages.msg.noRegisteredConverter(asType);
        }
        return conv;
    }

    <T> Converter<T> getConverterOrNull(Class<T> asType) {
        Converter<?> exactConverter = this.converters.get(asType);
        if (exactConverter != null) {
            return exactConverter;
        }
        if (asType.isPrimitive()) {
            return this.getConverterOrNull(Converters.wrapPrimitiveType(asType));
        }
        if (asType.isArray()) {
            Converter<?> conv = this.getConverterOrNull(asType.getComponentType());
            return conv == null ? null : Converters.newArrayConverter(conv, asType);
        }
        return this.converters.computeIfAbsent(asType, clazz -> ImplicitConverters.getConverter((Class)clazz));
    }

    public <T> T unwrap(Class<T> type) {
        if (Config.class.isAssignableFrom(type)) {
            return type.cast(this);
        }
        throw ConfigMessages.msg.getTypeNotSupportedForUnwrapping(type);
    }

    @Experimental(value="To retrive active profiles")
    public List<String> getProfiles() {
        return this.configSources.getProfiles();
    }

    private Object writeReplace() throws ObjectStreamException {
        return RegisteredConfig.instance;
    }

    private static class RegisteredConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final RegisteredConfig instance = new RegisteredConfig();

        private RegisteredConfig() {
        }

        private Object readResolve() throws ObjectStreamException {
            return ConfigProvider.getConfig();
        }
    }

    static class ConfigSourceInterceptorWithPriority
    implements Comparable<ConfigSourceInterceptorWithPriority>,
    Serializable {
        private static final long serialVersionUID = 1637460029437579033L;
        private final Function<ConfigSourceInterceptorContext, ConfigSourceInterceptor> init;
        private final int priority;
        private final int loadPriority = loadPrioritySequence--;
        private final String name;
        private final Type type;
        private ConfigSourceInterceptor interceptor;
        private static int loadPrioritySequence = 0;
        private static int loadPrioritySequenceNumber = 1;

        ConfigSourceInterceptorWithPriority(SmallRyeConfigBuilder.InterceptorWithPriority interceptor) {
            this.init = interceptor::getInterceptor;
            this.priority = interceptor.getPriority();
            this.name = "undefined";
            this.type = Type.INTERCEPTOR;
        }

        ConfigSourceInterceptorWithPriority(ConfigSource configSource) {
            this.init = context -> SmallRyeConfigSourceInterceptor.configSourceInterceptor(configSource);
            this.priority = configSource.getOrdinal();
            this.name = configSource.getName();
            this.type = Type.CONFIG_SOURCE;
        }

        private ConfigSourceInterceptorWithPriority(ConfigSourceInterceptor interceptor, int priority, String name) {
            this.init = null;
            this.priority = priority;
            this.name = name;
            this.interceptor = interceptor;
            this.type = Type.INTERCEPTOR;
        }

        ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
            if (this.interceptor == null) {
                this.interceptor = this.init.apply(context);
            }
            return this.interceptor;
        }

        ConfigSourceInterceptor getInterceptor() {
            if (this.interceptor == null) {
                throw new IllegalStateException();
            }
            return this.interceptor;
        }

        ConfigSourceInterceptorWithPriority initialized(ConfigSourceInterceptorContext context) {
            return new ConfigSourceInterceptorWithPriority(this.getInterceptor(context), this.priority, this.name);
        }

        static void raiseLoadPriority() {
            loadPrioritySequence = 1000 * ++loadPrioritySequenceNumber;
        }

        @Override
        public int compareTo(ConfigSourceInterceptorWithPriority other) {
            if (this.type.equals((Object)other.type)) {
                int res = Integer.compare(this.priority, other.priority);
                return res != 0 ? res : Integer.compare(this.loadPriority, other.loadPriority);
            }
            if (this.type.equals((Object)Type.INTERCEPTOR)) {
                return 1;
            }
            return -1;
        }

        static enum Type {
            INTERCEPTOR,
            CONFIG_SOURCE;

        }
    }

    private static class ConfigSources
    implements Serializable {
        private static final long serialVersionUID = 3483018375584151712L;
        private final List<ConfigSource> sources;
        private final List<ConfigSourceInterceptorWithPriority> interceptors;
        private final ConfigSourceInterceptorContext interceptorChain;

        ConfigSources(List<ConfigSource> sources, List<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors) {
            ArrayList<ConfigSourceInterceptorWithPriority> sortInterceptors = new ArrayList<ConfigSourceInterceptorWithPriority>();
            sortInterceptors.addAll(ConfigSources.mapSources(sources));
            sortInterceptors.addAll(ConfigSources.mapInterceptors(interceptors));
            sortInterceptors.sort(null);
            SmallRyeConfigSourceInterceptorContext current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (ConfigSourceInterceptorWithPriority configSourceInterceptor : sortInterceptors) {
                current = new SmallRyeConfigSourceInterceptorContext(configSourceInterceptor.getInterceptor(current), current);
            }
            sortInterceptors.addAll(ConfigSources.mapLateSources(current, sources, ConfigSources.getProfiles(sortInterceptors)));
            sortInterceptors.sort(null);
            ArrayList<ConfigSourceInterceptorWithPriority> initInterceptors = new ArrayList<ConfigSourceInterceptorWithPriority>();
            current = new SmallRyeConfigSourceInterceptorContext(ConfigSourceInterceptor.EMPTY, null);
            for (ConfigSourceInterceptorWithPriority configSourceInterceptor : sortInterceptors) {
                ConfigSourceInterceptorWithPriority initInterceptor = configSourceInterceptor.initialized(current);
                current = new SmallRyeConfigSourceInterceptorContext(initInterceptor.getInterceptor(), current);
                initInterceptors.add(initInterceptor);
            }
            this.interceptorChain = current;
            this.sources = Collections.unmodifiableList(ConfigSources.getSources(initInterceptors));
            this.interceptors = Collections.unmodifiableList(initInterceptors);
        }

        private static List<ConfigSourceInterceptorWithPriority> mapSources(List<ConfigSource> sources) {
            ConfigSourceInterceptorWithPriority.raiseLoadPriority();
            ArrayList<ConfigSourceInterceptorWithPriority> sourcesWithPriority = new ArrayList<ConfigSourceInterceptorWithPriority>();
            for (ConfigSource source : sources) {
                if (source instanceof ConfigurableConfigSource) continue;
                sourcesWithPriority.add(new ConfigSourceInterceptorWithPriority(source));
            }
            return sourcesWithPriority;
        }

        private static List<ConfigSourceInterceptorWithPriority> mapInterceptors(List<SmallRyeConfigBuilder.InterceptorWithPriority> interceptors) {
            ArrayList<ConfigSourceInterceptorWithPriority> sourcesWithPriority = new ArrayList<ConfigSourceInterceptorWithPriority>();
            for (SmallRyeConfigBuilder.InterceptorWithPriority interceptor : interceptors) {
                sourcesWithPriority.add(new ConfigSourceInterceptorWithPriority(interceptor));
            }
            return sourcesWithPriority;
        }

        private static List<String> getProfiles(List<ConfigSourceInterceptorWithPriority> interceptors) {
            for (ConfigSourceInterceptorWithPriority interceptor : interceptors) {
                if (!(interceptor.getInterceptor() instanceof ProfileConfigSourceInterceptor)) continue;
                return Arrays.asList(((ProfileConfigSourceInterceptor)interceptor.getInterceptor()).getProfiles());
            }
            return Collections.emptyList();
        }

        private static List<ConfigSourceInterceptorWithPriority> mapLateSources(final SmallRyeConfigSourceInterceptorContext initChain, List<ConfigSource> sources, final List<String> profiles) {
            ArrayList<ConfigurableConfigSource> lateSources = new ArrayList<ConfigurableConfigSource>();
            for (ConfigSource source : sources) {
                if (!(source instanceof ConfigurableConfigSource)) continue;
                lateSources.add((ConfigurableConfigSource)source);
            }
            lateSources.sort(Comparator.comparingInt(ConfigurableConfigSource::getOrdinal));
            ConfigSourceInterceptorWithPriority.raiseLoadPriority();
            ArrayList<ConfigSourceInterceptorWithPriority> sourcesWithPriority = new ArrayList<ConfigSourceInterceptorWithPriority>();
            for (ConfigurableConfigSource configurableSource : lateSources) {
                List<ConfigSource> configSources = configurableSource.getConfigSources(new ConfigSourceContext(){

                    @Override
                    public ConfigValue getValue(String name) {
                        ConfigValue value = initChain.proceed(name);
                        return value != null ? value : ConfigValue.builder().withName(name).build();
                    }

                    @Override
                    public List<String> getProfiles() {
                        return profiles;
                    }

                    @Override
                    public Iterator<String> iterateNames() {
                        return initChain.iterateNames();
                    }
                });
                for (ConfigSource configSource : configSources) {
                    sourcesWithPriority.add(new ConfigSourceInterceptorWithPriority(configSource));
                }
            }
            return sourcesWithPriority;
        }

        private static List<ConfigSource> getSources(List<ConfigSourceInterceptorWithPriority> interceptors) {
            ArrayList<ConfigSource> sources = new ArrayList<ConfigSource>();
            for (ConfigSourceInterceptorWithPriority interceptor : interceptors) {
                if (!(interceptor.getInterceptor() instanceof SmallRyeConfigSourceInterceptor)) continue;
                sources.add(((SmallRyeConfigSourceInterceptor)interceptor.getInterceptor()).getSource());
            }
            Collections.reverse(sources);
            return sources;
        }

        List<ConfigSource> getSources() {
            return this.sources;
        }

        List<ConfigSourceInterceptorWithPriority> getInterceptors() {
            return this.interceptors;
        }

        ConfigSourceInterceptorContext getInterceptorChain() {
            return this.interceptorChain;
        }

        List<String> getProfiles() {
            for (ConfigSourceInterceptorWithPriority interceptor : this.getInterceptors()) {
                if (!(interceptor.getInterceptor() instanceof ProfileConfigSourceInterceptor)) continue;
                return Arrays.asList(((ProfileConfigSourceInterceptor)interceptor.getInterceptor()).getProfiles());
            }
            return Collections.emptyList();
        }
    }
}

