/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.maltego.cloud.crypto.util.CryptoUtilities;
import com.maltego.cloud.data.PaddingConfig;
import com.maltego.cloud.data.SymmetricEncryptionConfig;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GraphEncryptionConfig {
    private final SymmetricEncryptionConfig atomicEncryptionConfig;
    private final List<String> atomicEncryptionPaths;
    private final SymmetricEncryptionConfig bulkEncryptionConfig;
    private final List<String> bulkEncryptionPaths;
    private final PaddingConfig valuePadding;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public GraphEncryptionConfig(@JsonProperty(value="atomicEncryptionConfig", required=true) SymmetricEncryptionConfig atomicEncryptionConfig, @JsonProperty(value="atomicEncryptionPaths", required=true) List<String> atomicEncryptionPaths, @JsonProperty(value="bulkEncryptionConfig", required=true) SymmetricEncryptionConfig bulkEncryptionConfig, @JsonProperty(value="bulkEncryptionPaths", required=true) List<String> bulkEncryptionPaths, @JsonProperty(value="valuePadding", required=true) PaddingConfig valuePadding) {
        this.atomicEncryptionConfig = atomicEncryptionConfig;
        this.atomicEncryptionPaths = atomicEncryptionPaths;
        this.bulkEncryptionConfig = bulkEncryptionConfig;
        this.bulkEncryptionPaths = bulkEncryptionPaths;
        this.valuePadding = valuePadding;
    }

    public List<String> getAtomicEncryptionPaths() {
        return this.atomicEncryptionPaths;
    }

    public SymmetricEncryptionConfig getAtomicEncryptionConfig() {
        return this.atomicEncryptionConfig;
    }

    public List<String> getBulkEncryptionPaths() {
        return this.bulkEncryptionPaths;
    }

    public SymmetricEncryptionConfig getBulkEncryptionConfig() {
        return this.bulkEncryptionConfig;
    }

    public PaddingConfig getValuePadding() {
        return this.valuePadding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphEncryptionConfig)) {
            return false;
        }
        GraphEncryptionConfig config = (GraphEncryptionConfig)o;
        return Objects.equals(this.atomicEncryptionPaths, config.atomicEncryptionPaths) && Objects.equals(this.atomicEncryptionConfig, config.atomicEncryptionConfig) && Objects.equals(this.bulkEncryptionPaths, config.bulkEncryptionPaths) && Objects.equals(this.bulkEncryptionConfig, config.bulkEncryptionConfig) && Objects.equals(this.valuePadding, config.valuePadding);
    }

    public int hashCode() {
        return Objects.hash(this.atomicEncryptionPaths, this.atomicEncryptionConfig, this.bulkEncryptionPaths, this.bulkEncryptionConfig, this.valuePadding);
    }

    public String toString() {
        return "GraphEncryptionConfig{atomicEncryptionPaths=" + this.atomicEncryptionPaths + ", atomicEncryptionConfig=" + this.atomicEncryptionConfig + ", bulkEncryptionPaths=" + this.bulkEncryptionPaths + ", bulkEncryptionConfig=" + this.bulkEncryptionConfig + ", valuePadding=" + this.valuePadding + '}';
    }

    public static GraphEncryptionConfig createForNewGraph() {
        ArrayList<String> atomicEncryptionPaths = new ArrayList<String>();
        atomicEncryptionPaths.add(".name");
        atomicEncryptionPaths.add(".metadata");
        SymmetricEncryptionConfig atomicEncryptionConfig = new SymmetricEncryptionConfig("AES256_GCM");
        ArrayList<String> bulkEncryptionPaths = new ArrayList<String>();
        bulkEncryptionPaths.add(".entities.props.value");
        bulkEncryptionPaths.add(".links.props.value");
        SymmetricEncryptionConfig bulkEncryptionConfig = new SymmetricEncryptionConfig(Base64.getEncoder().encodeToString(CryptoUtilities.generateIV()), null, "AES256_GCM");
        PaddingConfig padding = new PaddingConfig(4, "PKCS7");
        return new GraphEncryptionConfig(atomicEncryptionConfig, atomicEncryptionPaths, bulkEncryptionConfig, bulkEncryptionPaths, padding);
    }

    public static GraphEncryptionConfig createForNewVersion(GraphEncryptionConfig configForOldVersion) {
        SymmetricEncryptionConfig atomicEncryptionConfig = new SymmetricEncryptionConfig("AES256_GCM");
        SymmetricEncryptionConfig bulkEncryptionConfig = new SymmetricEncryptionConfig(Base64.getEncoder().encodeToString(CryptoUtilities.generateIV()), null, "AES256_GCM");
        return new GraphEncryptionConfig(atomicEncryptionConfig, configForOldVersion.getAtomicEncryptionPaths(), bulkEncryptionConfig, configForOldVersion.getBulkEncryptionPaths(), configForOldVersion.getValuePadding());
    }
}

