/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor.favs;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.util.Lookup;

public class TransformFavorites {
    public static final String PROP_FAVORITES_CHANGED = "transforms.favorites";
    public static TransformFavorites _default;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    public static synchronized TransformFavorites getDefault() {
        if (_default == null && (_default = (TransformFavorites)Lookup.getDefault().lookup(TransformFavorites.class)) == null) {
            _default = new TransformFavorites();
        }
        return _default;
    }

    public void setFavorite(TransformDefinition transform, boolean favorite) {
        if (transform.isFavorite() != favorite) {
            transform.setFavorite(favorite);
            TransformRepositoryRegistry registry = TransformRepositoryRegistry.getDefault();
            TransformRepository repository = registry.getRepository(transform.getRepositoryName());
            repository.updateSettings(transform);
            this._changeSupport.firePropertyChange(PROP_FAVORITES_CHANGED, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }
}

