/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.editing.propertygrid.PropertyDescriptorProperty;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageFileFilter;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

class ImageFileProperty
extends PropertyDescriptorProperty {
    private File _lastFile;

    public ImageFileProperty(DisplayDescriptor descriptor, DataSource data) {
        super(File.class, (PropertyDescriptor)descriptor, data);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.setValue("filter", new ImageFileFilter());
        this.updateImage((Image)this.getDataSource().getValue((PropertyDescriptor)descriptor));
    }

    @Override
    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this._lastFile;
    }

    @Override
    public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this._lastFile = (File)object;
        if (this._lastFile != null) {
            if (!this._lastFile.isDirectory()) {
                try {
                    this.updateImage(this.loadImage(this._lastFile));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        } else {
            this.updateImage(null);
        }
    }

    private void updateImage(Image image) {
        ImageIcon icon;
        String display;
        this.getDataSource().setValue(this.getPropertyDescriptor(), (Object)image);
        if (image == null) {
            display = "(none)";
            icon = new ImageIcon();
        } else {
            display = "(" + image.getWidth(null) + "x" + image.getHeight(null) + ")";
            icon = new ImageIcon(ImageUtils.smartSize((BufferedImage)ImageUtils.createBufferedImage((Image)image), (double)IconSize.TINY.getSize()));
        }
        this.setValue("htmlDisplayValue", display);
        this.setValue("valueIcon", icon);
    }

    private BufferedImage loadImage(File file) throws IOException {
        BufferedImage image = ImageIO.read(file);
        return image;
    }
}

