/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.nodes;

import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.typing.editing.propertygrid.PropertySheetFactory;
import com.paterva.maltego.ui.graph.nodes.NodePropertySupport;
import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static void addPartFindProperties(Sheet sheet, Node node, String snippet) {
        Sheet.Set set = PropertyUtils.getFindInfoSet(sheet);
        set.put((Node.Property)new PartSnippet(node, snippet));
    }

    public static void addGraphFindProperties(Sheet sheet, Node node) {
        Sheet.Set set = PropertyUtils.getFindInfoSet(sheet);
        set.put((Node.Property)new TotalMatches(node));
    }

    private static Sheet.Set getFindInfoSet(Sheet sheet) {
        return PropertySheetFactory.getSet((Sheet)sheet, (String)"findinfo", (String)"Find info", (String)"Properties related to the find results");
    }

    public static class TotalMatches
    extends MatchInfo {
        public TotalMatches(Node node) {
            super(node, "Matches", "Find match count.");
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            FindInFilesResult result = (FindInFilesResult)this.node().getLookup().lookup(FindInFilesResult.class);
            int matches = result.getMatchedParts().size();
            return matches + " matches";
        }
    }

    public static class PartSnippet
    extends MatchInfo {
        private String _snippet;

        public PartSnippet(Node node, String snippet) {
            super(node, "Snippet", "Find snippet.");
            this._snippet = snippet;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this._snippet;
        }
    }

    public static abstract class MatchInfo
    extends NodePropertySupport.ReadOnly<String> {
        public MatchInfo(Node node, String displayName, String description) {
            super(node, "maltego.fixed.find.match", String.class, displayName, description);
        }
    }
}

