/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ui.table.RowHeightProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.Timer;

public class TableRowHeightAnimator
implements ActionListener {
    private JTable _table;
    private RowHeightProvider _heightProvider;
    private Timer _timer;
    private int _expandedRow = -1;

    public TableRowHeightAnimator(JTable table, RowHeightProvider heightProvider) {
        this._table = table;
        this._heightProvider = heightProvider;
        this._timer = new Timer(20, this);
        this._timer.setRepeats(true);
        this._timer.setInitialDelay(0);
    }

    public void setExpandedRow(int row) {
        if (this._expandedRow != row) {
            this._expandedRow = row;
            if (!this._timer.isRunning()) {
                this._timer.start();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int rowCount = this._table.getRowCount();
        boolean changed = false;
        for (int row = 0; row < rowCount; ++row) {
            int goalHeight;
            int height = this._table.getRowHeight(row);
            int n = goalHeight = row == this._expandedRow ? this._heightProvider.getExpandedHeight(row) : this._heightProvider.getCollapsedHeight(row);
            if (height == goalHeight) continue;
            int adjustment = (goalHeight - height) / 3;
            if (adjustment == 0) {
                adjustment = goalHeight > height ? 1 : -1;
            }
            this._table.setRowHeight(row, height + adjustment);
            changed = true;
        }
        if (!changed) {
            this._timer.stop();
        } else {
            this._table.repaint();
        }
    }
}

