/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.ui.table.ButtonNameProvider;
import com.paterva.maltego.util.ui.table.ModelDecorator;
import com.paterva.maltego.util.ui.table.TableButtonCallback;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventObject;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

final class TableButtonCellEditor
extends DefaultCellEditor
implements TableCellRenderer {
    private boolean _isPushed;
    private TableButtonListener _buttonListener;
    private JTable _editingTable;
    private int _editingRow;
    private ActionEvent _editingEvent;
    private String _editingValue;
    private ButtonNameProvider _nameProvider;
    int _row = -1;
    int _col = -1;
    private final Map<String, ButtonPair> _editButtons = new ListMap();
    private final Map<String, ButtonPair> _renderButtons = new ListMap();

    public TableButtonCellEditor() {
        this(null, new JButton[0]);
    }

    public TableButtonCellEditor(TableButtonListener listener, JButton[] buttons) {
        this(listener, buttons, new boolean[buttons.length], new boolean[buttons.length]);
    }

    public TableButtonCellEditor(TableButtonListener listener, JButton[] buttons, boolean[] multiSelect, boolean[] drawBorder) {
        this(listener, buttons, multiSelect, drawBorder, new TableButtonCallback[buttons.length], null);
    }

    public TableButtonCellEditor(TableButtonListener listener, JButton[] buttons, boolean[] multiSelect, boolean[] drawBorder, TableButtonCallback[] callback, ButtonNameProvider nameProvider) {
        super(new JCheckBox());
        this._buttonListener = listener;
        if (buttons.length != multiSelect.length) {
            throw new IllegalArgumentException("buttons and multiSelect arrays must be of equal length");
        }
        if (buttons.length != drawBorder.length) {
            throw new IllegalArgumentException("buttons and drawBorder arrays must be of equal length");
        }
        for (int i = 0; i < buttons.length; ++i) {
            this.addButton(buttons[i], multiSelect[i], drawBorder[i], callback[i]);
        }
        this._nameProvider = nameProvider;
    }

    public void setRowOver(int row) {
        this._row = row;
    }

    public void setColOver(int col) {
        this._col = col;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        ModelDecorator.ActionDecorator marker = (ModelDecorator.ActionDecorator)value;
        this._editingValue = marker.getCommand();
        ButtonPair pair = this._editButtons.get(this._editingValue);
        if (pair == null) {
            throw new NullPointerException("No button registered to handle action " + this._editingValue);
        }
        JButton editButton = pair.getButton();
        editButton.setEnabled(pair.getCallback().isButtonEnabled(table, this._editingValue, row));
        if (!pair.isDrawBorder()) {
            if (isSelected) {
                editButton.setForeground(table.getSelectionForeground());
                editButton.setBackground(table.getSelectionBackground());
            } else {
                editButton.setForeground(table.getForeground());
                editButton.setBackground(table.getBackground());
            }
        }
        this._isPushed = editButton.isEnabled();
        this._editingTable = table;
        this._editingRow = row;
        this.setName(editButton, row, column);
        return editButton;
    }

    private void setName(JButton editButton, int row, int column) {
        String name;
        if (this._nameProvider != null && (name = this._nameProvider.getName(row, column)) != null) {
            editButton.setText(name);
        }
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        if (this._editingTable.isRowSelected(this._editingRow)) {
            return !this.allowMultiSelect(this._editingValue);
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (this._isPushed && this._buttonListener != null) {
            this._buttonListener.actionPerformed(new TableButtonEvent((Object)this._editingTable, this._editingEvent.getID(), this._editingEvent.getActionCommand(), this._editingTable.getSelectedRows()));
        }
        this._isPushed = false;
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        this._isPushed = false;
        this._editingTable = null;
        this._editingRow = -1;
        this._editingValue = null;
        this._editingEvent = null;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JButton renderButton;
        ModelDecorator.ActionDecorator marker = (ModelDecorator.ActionDecorator)value;
        if (marker == null) {
            renderButton = new JButton();
        } else {
            ButtonPair pair = this._renderButtons.get(marker.getCommand());
            if (pair == null) {
                throw new NullPointerException("No button registered to handle action " + marker.getCommand());
            }
            renderButton = pair.getButton();
            if (renderButton.getChangeListeners().length != 0) {
                renderButton.removeChangeListener(renderButton.getChangeListeners()[0]);
            }
            renderButton.setEnabled(pair.getCallback().isButtonEnabled(table, marker.getCommand(), row));
            if (!pair.isDrawBorder()) {
                renderButton.setBorder(new EmptyBorder(0, 5, 0, 5));
            }
        }
        if (row == this._row && column == this._col) {
            renderButton.setForeground(table.getSelectionForeground());
            renderButton.setBackground(table.getSelectionBackground());
        } else {
            renderButton.setForeground(table.getForeground());
            renderButton.setBackground(table.getBackground());
        }
        this.setName(renderButton, row, column);
        return renderButton;
    }

    public TableButtonListener getButtonListener() {
        return this._buttonListener;
    }

    public void setButtonListener(TableButtonListener buttonListener) {
        this._buttonListener = buttonListener;
    }

    private boolean allowMultiSelect(String action) {
        ButtonPair pair = this._editButtons.get(action);
        if (pair == null) {
            throw new NullPointerException("No button registered to handle action " + action);
        }
        return pair.isMultiSelect();
    }

    public void addButton(JButton button, boolean allowMultiSelect) {
        this.addButton(button, allowMultiSelect);
    }

    public void addButton(JButton button, boolean allowMultiSelect, boolean drawBorder, TableButtonCallback cb) {
        JButton editButton = this.copyButton(button);
        this._editButtons.put(button.getActionCommand(), new ButtonPair(editButton, allowMultiSelect, drawBorder, cb));
        editButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TableButtonCellEditor.this.stopCellEditing();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableButtonCellEditor.this._editingEvent = e;
                TableButtonCellEditor.this.fireEditingStopped();
            }
        });
        this._renderButtons.put(button.getActionCommand(), new ButtonPair(this.copyButton(button), allowMultiSelect, drawBorder, cb));
    }

    public void removeButton(JButton button) {
        this._editButtons.remove(button.getActionCommand());
    }

    private JButton copyButton(JButton button) {
        JButton b = new JButton();
        b.setText(button.getText());
        b.setBorder(button.getBorder());
        b.setIcon(button.getIcon());
        b.setForeground(button.getForeground());
        b.setFont(button.getFont());
        b.setBackground(button.getBackground());
        b.setActionCommand(button.getActionCommand());
        b.setDisabledIcon(button.getDisabledIcon());
        b.setMargin(button.getMargin());
        b.setBorderPainted(button.isBorderPainted());
        b.setOpaque(b.isOpaque());
        b.setContentAreaFilled(button.isContentAreaFilled());
        return b;
    }

    private static class ButtonPair {
        private boolean _multiSelect;
        private final boolean _drawBorder;
        private JButton _button;
        private TableButtonCallback _callback;
        private static final TableButtonCallback defaultCallback = new TableButtonCallback(){

            @Override
            public boolean isButtonEnabled(JTable table, String action, int row) {
                return true;
            }
        };

        public ButtonPair(JButton button, boolean multiSelect, boolean drawBorder, TableButtonCallback cb) {
            this._button = button;
            this._multiSelect = multiSelect;
            this._drawBorder = drawBorder;
            this._callback = cb;
            if (this._callback == null) {
                this._callback = defaultCallback;
            }
        }

        public boolean isMultiSelect() {
            return this._multiSelect;
        }

        public boolean isDrawBorder() {
            return this._drawBorder;
        }

        public void setMultiSelect(boolean multiSelect) {
            this._multiSelect = multiSelect;
        }

        public JButton getButton() {
            return this._button;
        }

        public void setButton(JButton button) {
            this._button = button;
        }

        public TableButtonCallback getCallback() {
            return this._callback;
        }

        public void setCallback(TableButtonCallback callback) {
            this._callback = callback;
        }
    }
}

