/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnimatedImage
extends JPanel {
    private Image _staticImage;
    private Image[] _animatedImages;
    private Timer _timer;
    private int _animationIndex;

    public AnimatedImage(Image staticImage, Image[] animatedImages, int delay) {
        this._staticImage = staticImage;
        this._animatedImages = Arrays.copyOf(animatedImages, animatedImages.length);
        this._timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimatedImage.this._animationIndex++;
                if (AnimatedImage.this._animationIndex >= AnimatedImage.this._animatedImages.length) {
                    AnimatedImage.this._animationIndex = 0;
                }
                AnimatedImage.this.repaint();
            }
        });
        this._timer.setInitialDelay(0);
    }

    public void start() {
        this._timer.start();
    }

    public void stop() {
        this._timer.stop();
        this.repaint();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
        if (this._timer.isRunning()) {
            g.drawImage(this._animatedImages[this._animationIndex], this.getX(), this.getY(), null);
        } else {
            g.drawImage(this._staticImage, this.getX(), this.getY(), null);
        }
    }
}

