/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileExtensionFileFilter
extends FileFilter {
    private String _description;
    private String[] _extensions;
    private String _title;

    public FileExtensionFileFilter() {
        this(null);
    }

    public FileExtensionFileFilter(String[] extensions) {
        this(extensions, null);
    }

    public FileExtensionFileFilter(String extension, String title) {
        this(new String[]{extension}, title);
    }

    public FileExtensionFileFilter(String[] extensions, String title) {
        this._title = title;
        this.setExtensions(extensions);
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        if (this.getExtensions() == null) {
            return true;
        }
        String path = f.getName();
        for (String ext : this.getExtensions()) {
            if (!path.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public String getTitle() {
        if (this._title == null) {
            return "Supported files";
        }
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
        this.setExtensions(this._extensions);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String[] getExtensions() {
        return this._extensions;
    }

    public void setExtensions(String[] extensions) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getTitle());
        buffer.append(" (");
        this._extensions = extensions;
        if (extensions != null) {
            this._extensions = new String[extensions.length];
            for (int i = 0; i < extensions.length; ++i) {
                String s = extensions[i];
                if (!s.startsWith(".")) {
                    s = "." + s;
                }
                this._extensions[i] = s;
                buffer.append("*");
                buffer.append(s);
                buffer.append(",");
            }
        }
        this._description = buffer.substring(0, buffer.length() - 1) + ")";
    }
}

