/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session;

import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.XmlPullParserUtils;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class PayloadHelper {
    public static String parsePayload(String element, String payload) throws CollaborationException {
        return PayloadHelper.parsePayload(element, payload, true);
    }

    public static String createPayload(String element, String body) {
        return PayloadHelper.createPayload(element, body, true);
    }

    public static String parsePayload(String element, String payload, boolean escapeBody) throws CollaborationException {
        return PayloadHelper.getBody(element, payload, null, escapeBody);
    }

    public static String createPayload(String element, String body, boolean escapeBody) {
        return PayloadHelper.createPayload(element, null, body, escapeBody);
    }

    public static String createPayload(String element, Map<String, String> attributes, String body) {
        return PayloadHelper.createPayload(element, attributes, body, true);
    }

    public static String createPayload(String element, Map<String, String> attributes, String body, boolean escapeBody) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<");
        buffer.append(element);
        if (attributes != null) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                buffer.append(String.format(" %s=\"%s\"", attribute.getKey(), attribute.getValue()));
            }
        }
        buffer.append(">");
        if (body != null) {
            if (escapeBody) {
                body = PayloadHelper.escape(body);
            }
            buffer.append(body);
        }
        buffer.append(String.format("</%s>", element));
        return buffer.toString();
    }

    public static Collection<String> splitXml(String element, String xml) throws CollaborationException {
        if (xml == null || xml.trim().isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<String> list = new ArrayList<String>();
        String startElement = "<" + element;
        String endElement = String.format("</%s>", element);
        int start = xml.indexOf(startElement);
        while (start >= 0) {
            int end = xml.indexOf(endElement, start);
            if (end < 0) {
                throw new CollaborationException("No corresponding end element for start tag " + startElement, true);
            }
            list.add(xml.substring(start, end += endElement.length()));
            start = xml.indexOf(startElement, end);
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBody(String element, String xml, Map<String, String> attributes, boolean escapeBody) throws CollaborationException {
        if (xml == null) return null;
        if (xml.trim().isEmpty()) {
            return null;
        }
        try {
            XmlPullParser parser = PayloadHelper.parserFactory().newPullParser();
            StringBuilder body = new StringBuilder();
            try (StringReader reader = new StringReader(xml);){
                int eventType;
                parser.setInput((Reader)reader);
                int startDepth = -1;
                boolean stop = false;
                boolean start = false;
                do {
                    eventType = parser.next();
                    int currentDepth = parser.getDepth();
                    boolean bl = stop = currentDepth < startDepth;
                    if (start) {
                        body.append(XmlPullParserUtils.toXml(parser));
                    }
                    if (eventType == 2) {
                        if (start || !(start = element.equals(parser.getName())) || attributes == null) continue;
                        PayloadHelper.copyAttributes(parser, attributes);
                        continue;
                    }
                    if (eventType != 3) continue;
                    boolean bl2 = stop = currentDepth < startDepth;
                } while (!stop && eventType != 1);
                String result = body.toString();
                if (result != null && escapeBody) {
                    result = PayloadHelper.unescape(result);
                }
                String string = result;
                return string;
            }
        }
        catch (XmlPullParserException ex) {
            throw new CollaborationException(ex, true);
        }
    }

    private static XmlPullParserFactory parserFactory() throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    private static String[] splitEqualSign(String s) {
        int pos = s.indexOf(61);
        if (pos > 0) {
            String[] result = new String[]{s.substring(0, pos), PayloadHelper.stripQuotes(s.substring(pos + 1, s.length()))};
            return result;
        }
        return null;
    }

    private static String stripQuotes(String s) {
        int start = s.indexOf(34);
        int end = s.lastIndexOf(34);
        s = s.substring(start + 1, end);
        return PayloadHelper.unescape(s);
    }

    public static String escape(String text) {
        return XMLEscapeUtils.escape((String)text);
    }

    public static String unescape(String text) {
        return XMLEscapeUtils.unescape((String)text);
    }

    private static void copyAttributes(XmlPullParser from, Map<String, String> to) {
        for (int i = 0; i < from.getAttributeCount(); ++i) {
            String name = from.getAttributeName(i);
            String value = from.getAttributeValue(i);
            to.put(name, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getBodies(String xml) throws CollaborationException {
        try {
            XmlPullParser parser = PayloadHelper.parserFactory().newPullParser();
            LinkedHashMap<String, String> payloads = new LinkedHashMap<String, String>();
            try (StringReader reader = new StringReader(xml);){
                int eventType;
                boolean stop;
                parser.setInput((Reader)reader);
                boolean start = false;
                int startDepth = -1;
                do {
                    eventType = parser.next();
                    int currentDepth = parser.getDepth();
                    boolean bl = stop = currentDepth < startDepth;
                    if (eventType == 2) {
                        if (start) {
                            String body = XmlPullParserUtils.toXml(parser);
                            if (body != null) {
                                body = body.trim();
                            }
                            payloads.put(parser.getName(), body);
                            continue;
                        }
                        start = true;
                        continue;
                    }
                    if (eventType != 3) continue;
                    boolean bl2 = stop = currentDepth < startDepth;
                } while (!stop && eventType != 1);
                LinkedHashMap<String, String> linkedHashMap = payloads;
                return linkedHashMap;
            }
        }
        catch (XmlPullParserException ex) {
            throw new CollaborationException(ex, true);
        }
    }

    public static boolean isType(String type, String body) {
        if (body == null) {
            return false;
        }
        return body.trim().startsWith(String.format("<%s ", type));
    }
}

