/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.typing.editing.propertygrid.DisplayDescriptorProperty;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.nodes.ProxyProperty;
import java.util.ArrayList;
import java.util.Enumeration;
import org.openide.nodes.Node;

class FilteredPropertySet
extends Node.PropertySet {
    private final Node.PropertySet _original;
    private final String _exclusionFilter;

    public FilteredPropertySet(Node.PropertySet orig, String exclusionFilter) {
        this._original = orig;
        this._exclusionFilter = exclusionFilter;
    }

    public Node.Property<?>[] getProperties() {
        ArrayList<Node.Property> newProps = new ArrayList<Node.Property>();
        for (Node.Property p : this.getOriginal().getProperties()) {
            if (p.getName().startsWith(this._exclusionFilter)) continue;
            newProps.add(p);
        }
        return newProps.toArray(new Node.Property[newProps.size()]);
    }

    public boolean hasAttachmentProperty() {
        for (Node.Property p : this.getOriginal().getProperties()) {
            DisplayDescriptorProperty ddp;
            Node.Property delegate;
            if (!(p instanceof ProxyProperty) || !((delegate = ((ProxyProperty)p).getDelegate()) instanceof DisplayDescriptorProperty) || Attachments.class != (ddp = (DisplayDescriptorProperty)delegate).getDisplayDescriptor().getType()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<String> attributeNames() {
        return this.getOriginal().attributeNames();
    }

    public String getDisplayName() {
        return this.getOriginal().getDisplayName();
    }

    public String getHtmlDisplayName() {
        return this.getOriginal().getHtmlDisplayName();
    }

    public String getName() {
        return this.getOriginal().getName();
    }

    public Node.PropertySet getOriginal() {
        return this._original;
    }

    public String getShortDescription() {
        return this.getOriginal().getShortDescription();
    }

    public Object getValue(String attributeName) {
        return this.getOriginal().getValue(attributeName);
    }

    public boolean isExpert() {
        return this.getOriginal().isExpert();
    }

    public boolean isHidden() {
        return this.getOriginal().isHidden();
    }

    public boolean isPreferred() {
        return this.getOriginal().isPreferred();
    }

    public void setDisplayName(String displayName) {
        this.getOriginal().setDisplayName(displayName);
    }

    public void setExpert(boolean expert) {
        this.getOriginal().setExpert(expert);
    }

    public void setHidden(boolean hidden) {
        this.getOriginal().setHidden(hidden);
    }

    public void setName(String name) {
        this.getOriginal().setName(name);
    }

    public void setPreferred(boolean preferred) {
        this.getOriginal().setPreferred(preferred);
    }

    public void setShortDescription(String text) {
        this.getOriginal().setShortDescription(text);
    }

    public void setValue(String attributeName, Object value) {
        this.getOriginal().setValue(attributeName, value);
    }

    public String toString() {
        return this.getOriginal().toString();
    }

    public boolean equals(Object propertySet) {
        return this.getOriginal().equals(propertySet);
    }

    public int hashCode() {
        return this.getOriginal().hashCode();
    }
}

