/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters;

import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CookieSpecRegistries;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.keycloak.adapters.SniSSLSocketFactory;
import org.keycloak.common.util.EnvUtil;
import org.keycloak.common.util.KeystoreUtil;
import org.keycloak.representations.adapters.config.AdapterHttpClientConfig;

public class HttpClientBuilder {
    protected KeyStore truststore;
    protected KeyStore clientKeyStore;
    protected String clientPrivateKeyPassword;
    protected boolean disableTrustManager;
    protected boolean disableCookieCache = true;
    protected HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
    protected SSLContext sslContext;
    protected int connectionPoolSize = 100;
    protected int maxPooledPerRoute = 0;
    protected long connectionTTL = -1L;
    protected TimeUnit connectionTTLUnit = TimeUnit.MILLISECONDS;
    protected HostnameVerifier verifier = null;
    protected long socketTimeout = -1L;
    protected TimeUnit socketTimeoutUnits = TimeUnit.MILLISECONDS;
    protected long establishConnectionTimeout = -1L;
    protected TimeUnit establishConnectionTimeoutUnits = TimeUnit.MILLISECONDS;
    protected HttpHost proxyHost;
    private SPNegoSchemeFactory spNegoSchemeFactory;
    private boolean useSpNego;

    public HttpClientBuilder socketTimeout(long timeout, TimeUnit unit) {
        this.socketTimeout = timeout;
        this.socketTimeoutUnits = unit;
        return this;
    }

    public HttpClientBuilder establishConnectionTimeout(long timeout, TimeUnit unit) {
        this.establishConnectionTimeout = timeout;
        this.establishConnectionTimeoutUnits = unit;
        return this;
    }

    public HttpClientBuilder connectionTTL(long ttl, TimeUnit unit) {
        this.connectionTTL = ttl;
        this.connectionTTLUnit = unit;
        return this;
    }

    public HttpClientBuilder maxPooledPerRoute(int maxPooledPerRoute) {
        this.maxPooledPerRoute = maxPooledPerRoute;
        return this;
    }

    public HttpClientBuilder connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public HttpClientBuilder disableTrustManager() {
        this.disableTrustManager = true;
        return this;
    }

    public HttpClientBuilder disableCookieCache(boolean disable) {
        this.disableCookieCache = disable;
        return this;
    }

    public HttpClientBuilder hostnameVerification(HostnameVerificationPolicy policy) {
        this.policy = policy;
        return this;
    }

    public HttpClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public HttpClientBuilder trustStore(KeyStore truststore) {
        this.truststore = truststore;
        return this;
    }

    public HttpClientBuilder keyStore(KeyStore keyStore, String password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = password;
        return this;
    }

    public HttpClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientKeyStore = keyStore;
        this.clientPrivateKeyPassword = new String(password);
        return this;
    }

    public HttpClientBuilder spNegoSchemeFactory(SPNegoSchemeFactory spnegoSchemeFactory) {
        this.spNegoSchemeFactory = spnegoSchemeFactory;
        return this;
    }

    public HttpClientBuilder useSPNego(boolean useSpnego) {
        this.useSpNego = useSpnego;
        return this;
    }

    public HttpClient build() {
        VerifierWrapper verifier = null;
        if (this.verifier != null) {
            verifier = new VerifierWrapper(this.verifier);
        } else {
            switch (this.policy) {
                case ANY: {
                    verifier = new AllowAllHostnameVerifier();
                    break;
                }
                case WILDCARD: {
                    verifier = new BrowserCompatHostnameVerifier();
                    break;
                }
                case STRICT: {
                    verifier = new StrictHostnameVerifier();
                }
            }
        }
        try {
            BasicHttpClientConnectionManager cm;
            SniSSLSocketFactory sslsf;
            SSLContext theContext = this.sslContext;
            if (this.disableTrustManager) {
                theContext = SSLContext.getInstance("SSL");
                theContext.init(null, new TrustManager[]{new PassthroughTrustManager()}, new SecureRandom());
                verifier = new AllowAllHostnameVerifier();
                sslsf = new SniSSLSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else if (theContext != null) {
                sslsf = new SniSSLSocketFactory(theContext, (X509HostnameVerifier)verifier);
            } else if (this.clientKeyStore != null || this.truststore != null) {
                sslsf = new SniSSLSocketFactory("TLS", this.clientKeyStore, this.clientPrivateKeyPassword, this.truststore, null, verifier);
            } else {
                SSLContext tlsContext = SSLContext.getInstance("TLS");
                tlsContext.init(null, null, null);
                sslsf = new SniSSLSocketFactory(tlsContext, (X509HostnameVerifier)verifier);
            }
            RegistryBuilder sf = RegistryBuilder.create();
            sf.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            sf.register("https", (Object)sslsf);
            if (this.connectionPoolSize > 0) {
                PoolingHttpClientConnectionManager tcm = new PoolingHttpClientConnectionManager(sf.build());
                tcm.setMaxTotal(this.connectionPoolSize);
                if (this.maxPooledPerRoute == 0) {
                    this.maxPooledPerRoute = this.connectionPoolSize;
                }
                tcm.setDefaultMaxPerRoute(this.maxPooledPerRoute);
                cm = tcm;
            } else {
                cm = new BasicHttpClientConnectionManager((Lookup)sf.build());
            }
            SocketConfig.Builder socketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT);
            ConnectionConfig.Builder connConfig = ConnectionConfig.copy((ConnectionConfig)ConnectionConfig.DEFAULT);
            RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
            if (this.proxyHost != null) {
                requestConfig.setProxy(new HttpHost(this.proxyHost));
            }
            if (this.socketTimeout > -1L) {
                requestConfig.setSocketTimeout((int)this.socketTimeoutUnits.toMillis(this.socketTimeout));
            }
            if (this.establishConnectionTimeout > -1L) {
                requestConfig.setConnectTimeout((int)this.establishConnectionTimeoutUnits.toMillis(this.establishConnectionTimeout));
            }
            Registry cookieSpecs = CookieSpecRegistries.createDefaultBuilder().register("default", (Object)new DefaultCookieSpecProvider()).build();
            if (this.useSpNego) {
                requestConfig.setTargetPreferredAuthSchemes(Arrays.asList("Negotiate"));
            }
            org.apache.http.impl.client.HttpClientBuilder clientBuilder = org.apache.http.impl.client.HttpClientBuilder.create().setDefaultSocketConfig(socketConfig.build()).setDefaultConnectionConfig(connConfig.build()).setDefaultRequestConfig(requestConfig.build()).setDefaultCookieSpecRegistry((Lookup)cookieSpecs).setConnectionManager((HttpClientConnectionManager)cm);
            if (this.spNegoSchemeFactory != null) {
                RegistryBuilder authSchemes = RegistryBuilder.create();
                authSchemes.register("Negotiate", (Object)this.spNegoSchemeFactory);
                clientBuilder.setDefaultAuthSchemeRegistry((Lookup)authSchemes.build());
            }
            if (this.useSpNego) {
                Credentials fake = new Credentials(){

                    public String getPassword() {
                        return null;
                    }

                    public Principal getUserPrincipal() {
                        return null;
                    }
                };
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, fake);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if (this.disableCookieCache) {
                clientBuilder.setDefaultCookieStore(new CookieStore(){

                    public void addCookie(Cookie cookie) {
                    }

                    public List<Cookie> getCookies() {
                        return Collections.emptyList();
                    }

                    public boolean clearExpired(Date date) {
                        return false;
                    }

                    public void clear() {
                    }
                });
            }
            return clientBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpClient build(AdapterHttpClientConfig adapterConfig) {
        String clientKeystore;
        this.disableCookieCache(true);
        String truststorePath = adapterConfig.getTruststore();
        if (truststorePath != null) {
            truststorePath = EnvUtil.replace((String)truststorePath);
            String truststorePassword = adapterConfig.getTruststorePassword();
            try {
                this.truststore = KeystoreUtil.loadKeyStore((String)truststorePath, (String)truststorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore", e);
            }
        }
        if ((clientKeystore = adapterConfig.getClientKeystore()) != null) {
            clientKeystore = EnvUtil.replace((String)clientKeystore);
            String clientKeystorePassword = adapterConfig.getClientKeystorePassword();
            try {
                KeyStore clientCertKeystore = KeystoreUtil.loadKeyStore((String)clientKeystore, (String)clientKeystorePassword);
                this.keyStore(clientCertKeystore, clientKeystorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load keystore", e);
            }
        }
        int size = 10;
        if (adapterConfig.getConnectionPoolSize() > 0) {
            size = adapterConfig.getConnectionPoolSize();
        }
        HostnameVerificationPolicy policy = HostnameVerificationPolicy.WILDCARD;
        if (adapterConfig.isAllowAnyHostname()) {
            policy = HostnameVerificationPolicy.ANY;
        }
        this.connectionPoolSize(size);
        this.hostnameVerification(policy);
        if (adapterConfig.isDisableTrustManager()) {
            this.disableTrustManager();
        } else {
            this.trustStore(this.truststore);
        }
        this.configureProxyForAuthServerIfProvided(adapterConfig);
        if (this.socketTimeout == -1L && adapterConfig.getSocketTimeout() > 0L) {
            this.socketTimeout(adapterConfig.getSocketTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.establishConnectionTimeout == -1L && adapterConfig.getConnectionTimeout() > 0L) {
            this.establishConnectionTimeout(adapterConfig.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        }
        if (this.connectionTTL == -1L && adapterConfig.getConnectionTTL() > 0L) {
            this.connectionTTL(adapterConfig.getConnectionTTL(), TimeUnit.MILLISECONDS);
        }
        return this.build();
    }

    private void configureProxyForAuthServerIfProvided(AdapterHttpClientConfig adapterConfig) {
        if (adapterConfig == null || adapterConfig.getProxyUrl() == null || adapterConfig.getProxyUrl().trim().isEmpty()) {
            return;
        }
        URI uri = URI.create(adapterConfig.getProxyUrl());
        this.proxyHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    static class VerifierWrapper
    implements X509HostnameVerifier {
        protected HostnameVerifier verifier;

        VerifierWrapper(HostnameVerifier verifier) {
            this.verifier = verifier;
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            if (!this.verifier.verify(host, ssl.getSession())) {
                throw new SSLException("Hostname verification failure");
            }
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
            throw new SSLException("This verification path not implemented");
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
            throw new SSLException("This verification path not implemented");
        }

        public boolean verify(String s, SSLSession sslSession) {
            return this.verifier.verify(s, sslSession);
        }
    }

    private static class PassthroughTrustManager
    implements X509TrustManager {
        private PassthroughTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static enum HostnameVerificationPolicy {
        ANY,
        WILDCARD,
        STRICT;

    }
}

