/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ProtocolException;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.IDataSource;
import org.xsocket.MaxReadSizeExceededException;

public final class BlockingBodyDataSource
implements IDataSource,
ReadableByteChannel,
Closeable {
    private static final Logger LOG = Logger.getLogger(BlockingBodyDataSource.class.getName());
    public static final int DEFAULT_RECEIVE_TIMEOUT = Integer.MAX_VALUE;
    private final ReadNotificationHandler handler = new ReadNotificationHandler();
    private final Object readGuard = new Object();
    private final NonBlockingBodyDataSource delegee;
    private int receiveTimeoutSec = Integer.MAX_VALUE;

    BlockingBodyDataSource(NonBlockingBodyDataSource delegee) throws IOException {
        this.delegee = delegee;
        delegee.setSystemDataHandler(this.handler);
    }

    NonBlockingBodyDataSource getUnderliyingBodyDataSource() {
        return this.delegee;
    }

    public void setReceiveTimeoutSec(int timeout) {
        this.receiveTimeoutSec = timeout;
    }

    public int getReceiveTimeoutSec() {
        return this.receiveTimeoutSec;
    }

    public boolean isOpen() {
        return this.delegee.isOpen();
    }

    public void close() throws IOException {
        this.delegee.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws IOException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                if (this.delegee.isComplete()) {
                    return this.delegee.available();
                }
                this.checkAndWaitForMoreDate(remainingTime);
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    public void markReadPosition() {
        this.delegee.markReadPosition();
    }

    public boolean resetToReadMark() {
        return this.delegee.resetToReadMark();
    }

    public void removeReadMark() {
        this.delegee.removeReadMark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBuffer() throws IOException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                if (this.delegee.isComplete()) {
                    return this.readByteBufferByLength(this.delegee.available());
                }
                this.checkAndWaitForMoreDate(remainingTime);
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws IOException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                if (this.delegee.isComplete()) {
                    return this.readBytesByLength(this.delegee.available());
                }
                this.checkAndWaitForMoreDate(remainingTime);
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readString() throws IOException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                if (this.delegee.isComplete()) {
                    return this.readStringByLength(this.delegee.available());
                }
                this.checkAndWaitForMoreDate(remainingTime);
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    private void checkAndWaitForMoreDate(long remainingTime) throws IOException {
        if (!this.delegee.isComplete()) {
            if (!this.delegee.isMoreInputDataExpected()) {
                throw new IOException("incomplete body received (channel closed by peer?)");
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("body has not been complete received (current size=" + this.delegee.available() + "). waiting");
            }
        } else {
            throw new ClosedChannelException();
        }
        this.waitingForData(this.readGuard, remainingTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer) throws IOException {
        int size = buffer.remaining();
        if (size < 1) {
            return 0;
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        Object object = this.readGuard;
        synchronized (object) {
            do {
                int read;
                int availableSize;
                if ((availableSize = this.delegee.available()) > 0 && (read = this.delegee.read(buffer)) > 0) {
                    return read;
                }
                if (availableSize == -1) {
                    this.delegee.read(ByteBuffer.allocate(0));
                }
                if (!this.isOpen()) {
                    return -1;
                }
                this.waitingForData(this.readGuard, remainingTime);
            } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws IOException, BufferUnderflowException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByte();
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws IOException, BufferUnderflowException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readShort();
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws IOException, BufferUnderflowException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readInt();
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws IOException, BufferUnderflowException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readLong();
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readDouble() throws IOException, BufferUnderflowException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readDouble();
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    public ByteBuffer[] readByteBufferByDelimiter(String delimiter) throws IOException, BufferUnderflowException, SocketTimeoutException {
        return this.readByteBufferByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBufferByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, SocketTimeoutException {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByteBufferByDelimiter(delimiter, maxLength);
                }
                catch (MaxReadSizeExceededException mre) {
                    throw mre;
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer[] readByteBufferByLength(int length) throws IOException, BufferUnderflowException, SocketTimeoutException {
        if (length <= 0) {
            return new ByteBuffer[0];
        }
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            Object object = this.readGuard;
            synchronized (object) {
                try {
                    return this.delegee.readByteBufferByLength(length);
                }
                catch (BufferUnderflowException bue) {
                    if (this.delegee.isComplete()) {
                        throw new ClosedChannelException();
                    }
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    private long computeRemainingTime(long start, int receiveTimeoutSec) {
        return start + (long)receiveTimeoutSec * 1000L - System.currentTimeMillis();
    }

    public byte[] readBytesByDelimiter(String delimiter) throws IOException, BufferUnderflowException, SocketTimeoutException {
        return this.readBytesByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public byte[] readBytesByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByDelimiter(delimiter, maxLength));
    }

    public byte[] readBytesByLength(int length) throws IOException, BufferUnderflowException, SocketTimeoutException {
        return DataConverter.toBytes((ByteBuffer[])this.readByteBufferByLength(length));
    }

    public String readStringByDelimiter(String delimiter) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException {
        return this.readStringByDelimiter(delimiter, Integer.MAX_VALUE);
    }

    public String readStringByDelimiter(String delimiter, int maxLength) throws IOException, BufferUnderflowException, UnsupportedEncodingException, MaxReadSizeExceededException, SocketTimeoutException {
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByDelimiter(delimiter, maxLength), (String)this.delegee.getEncoding());
    }

    public String readStringByLength(int length) throws IOException, BufferUnderflowException, UnsupportedEncodingException, SocketTimeoutException {
        return DataConverter.toString((ByteBuffer[])this.readByteBufferByLength(length), (String)this.delegee.getEncoding());
    }

    public long transferTo(WritableByteChannel target, int length) throws IOException, BufferUnderflowException, SocketTimeoutException {
        ByteBuffer[] buffers;
        long written = 0L;
        for (ByteBuffer buffer : buffers = this.readByteBufferByLength(length)) {
            written += (long)target.write(buffer);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(WritableByteChannel target) throws IOException, BufferUnderflowException, SocketTimeoutException {
        long written = 0L;
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            int available;
            if ((available = this.delegee.available()) > 0) {
                written += this.transferTo(target, available);
            } else if (available == -1) {
                return written;
            }
            Object object = this.readGuard;
            synchronized (object) {
                if (this.delegee.available() == 0) {
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    public long transferTo(BodyDataSink dataSink) throws ProtocolException, IOException, ClosedChannelException, BufferUnderflowException {
        return this.transferTo(dataSink, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(BodyDataSink dataSink, int length) throws ProtocolException, IOException, ClosedChannelException, BufferUnderflowException {
        long written = 0L;
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        do {
            int available;
            if ((available = this.delegee.available()) >= length) {
                written += this.delegee.transferTo(dataSink, length);
            } else if (available == -1) {
                return written;
            }
            Object object = this.readGuard;
            synchronized (object) {
                if (this.delegee.available() < length) {
                    this.waitingForData(this.readGuard, remainingTime);
                }
            }
        } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("receive timeout " + this.receiveTimeoutSec + " sec reached. throwing timeout exception");
        }
        throw new SocketTimeoutException("timeout " + this.receiveTimeoutSec + " sec reached");
    }

    private void waitingForData(Object readGuard, long maxWaittime) {
        try {
            readGuard.wait(maxWaittime);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReadDataInserted() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.delegee.getId() + "] read notification called");
        }
        Object object = this.readGuard;
        synchronized (object) {
            this.readGuard.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long start = System.currentTimeMillis();
        long remainingTime = this.receiveTimeoutSec;
        try {
            do {
                Object object = this.readGuard;
                synchronized (object) {
                    if (this.delegee.isComplete()) {
                        return this.delegee.toString();
                    }
                    if (!this.delegee.isComplete()) {
                        this.waitingForData(this.readGuard, remainingTime);
                    }
                }
            } while ((remainingTime = this.computeRemainingTime(start, this.receiveTimeoutSec)) > 0L);
            return "timeout error occured within toString method";
        }
        catch (IOException ioe) {
            return "error occured by performing toString: " + ioe.toString();
        }
    }

    @Execution(value=0)
    private final class ReadNotificationHandler
    implements IBodyDataHandler {
        private ReadNotificationHandler() {
        }

        public boolean onData(NonBlockingBodyDataSource bodyDataSource) {
            BlockingBodyDataSource.this.onReadDataInserted();
            return true;
        }
    }
}

