/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PhoneNumber {
    private static final Logger LOG = Logger.getLogger(PhoneNumber.class.getName());
    private static final String UNKNOWN_REGION = "ZZ";
    private final String creationString;
    private final Phonenumber.PhoneNumber phoneNumber;

    public static PhoneNumber parse(String value) {
        Phonenumber.PhoneNumber phoneNumber = null;
        if (value == null) {
            value = "";
        } else {
            try {
                value = value.replaceAll("@", "");
                PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
                phoneNumber = phoneUtil.parse((CharSequence)value, UNKNOWN_REGION);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "Error creating phone number: {0}", ex.getMessage());
            }
        }
        return new PhoneNumber(phoneNumber, value);
    }

    private PhoneNumber(Phonenumber.PhoneNumber phoneNumber, String creationString) {
        this.phoneNumber = phoneNumber;
        this.creationString = creationString;
    }

    public String getCreationString() {
        return this.creationString;
    }

    public Optional<Phonenumber.PhoneNumber> getInternal() {
        return Optional.ofNullable(this.phoneNumber);
    }

    public String getRegion() {
        if (this.phoneNumber == null) {
            return "";
        }
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        return phoneUtil.getRegionCodeForNumber(this.phoneNumber);
    }

    public String getNumberType() {
        if (this.phoneNumber == null) {
            return "";
        }
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        PhoneNumberUtil.PhoneNumberType type = phoneUtil.getNumberType(this.phoneNumber);
        switch (type) {
            case FIXED_LINE: {
                return "Fixed Line";
            }
            case FIXED_LINE_OR_MOBILE: {
                return "Fixed or Mobile";
            }
            case MOBILE: {
                return "Mobile";
            }
            case PAGER: {
                return "Pager";
            }
            case PERSONAL_NUMBER: {
                return "Personal Number";
            }
            case PREMIUM_RATE: {
                return "Premium Rate";
            }
            case SHARED_COST: {
                return "Shared Cost";
            }
            case TOLL_FREE: {
                return "Toll Free";
            }
            case UAN: {
                return "Company Number";
            }
            case VOICEMAIL: {
                return "Voicemail";
            }
            case VOIP: {
                return "VoIP";
            }
        }
        return "Unknown";
    }

    public String getExtension() {
        if (this.phoneNumber == null) {
            return "";
        }
        return this.phoneNumber.getExtension();
    }

    public String toStringNational() {
        if (this.phoneNumber == null) {
            return "";
        }
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        return phoneUtil.format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
    }

    public String toStringInternational() {
        if (this.phoneNumber == null) {
            return "";
        }
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        return phoneUtil.format(this.phoneNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
    }

    public String toString() {
        return this.phoneNumber != null ? this.toStringInternational() : this.creationString;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.phoneNumber);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber)obj;
        if (this.phoneNumber != null || other.phoneNumber != null) {
            return Objects.equals(this.phoneNumber, other.phoneNumber);
        }
        return Objects.equals(this.creationString, other.creationString);
    }
}

