/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.transforms;

import com.paterva.maltego.typing.serializer.AttachmentsPathRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.StringUtilities;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.transform.Transform;

public class AttachmentsTransform
implements Transform<Attachments> {
    private static final Logger LOG = Logger.getLogger(AttachmentsTransform.class.getName());

    public Attachments read(String value) throws Exception {
        Map<Integer, String> paths = AttachmentsPathRegistry.getPaths();
        if (!StringUtilities.isNullOrEmpty((String)value) && paths != null) {
            String primaryImage;
            LOG.log(Level.FINE, "Read attachments: {0}", value);
            String[] tokens = value.split("\\|");
            int count = Integer.valueOf(tokens[0]);
            int primaryImageIndex = -1;
            int primaryImageTokenIndex = count + 1;
            if (tokens.length > primaryImageTokenIndex && !StringUtilities.isNullOrEmpty((String)(primaryImage = tokens[primaryImageTokenIndex].trim()))) {
                primaryImageIndex = Integer.valueOf(primaryImage);
            }
            Attachments atts = new Attachments(count);
            for (int i = 1; i <= count; ++i) {
                String path = tokens[i];
                int id = -1;
                for (Map.Entry<Integer, String> entry : paths.entrySet()) {
                    if (!path.equals(entry.getValue())) continue;
                    id = entry.getKey();
                    break;
                }
                if (id < 0) continue;
                Attachment att = new Attachment(id, null);
                atts.add(att);
                if (i != primaryImageIndex + 1) continue;
                atts.setPrimaryImage(att);
            }
            return atts;
        }
        return null;
    }

    public String write(Attachments value) throws Exception {
        if (value instanceof Attachments) {
            StringBuilder sb = new StringBuilder();
            Attachments atts = value;
            sb.append(atts.size());
            sb.append('|');
            Map<Integer, String> paths = AttachmentsPathRegistry.getPaths();
            int index = 0;
            int primaryImageIndex = -1;
            for (Attachment att : atts) {
                String path = paths.get(att.getId());
                sb.append(path);
                sb.append('|');
                if (att.equals(atts.getPrimaryImage())) {
                    primaryImageIndex = index;
                }
                ++index;
            }
            if (primaryImageIndex != -1) {
                sb.append(primaryImageIndex);
            }
            String text = sb.toString();
            LOG.log(Level.FINE, "Write attachments: {0}", text);
            return text;
        }
        return null;
    }
}

