// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/sigstore/rekor/pkg/generated/models"
)

// GetLogEntryByIndexOKCode is the HTTP code returned for type GetLogEntryByIndexOK
const GetLogEntryByIndexOKCode int = 200

/*
GetLogEntryByIndexOK the entry in the transparency log requested along with an inclusion proof

swagger:response getLogEntryByIndexOK
*/
type GetLogEntryByIndexOK struct {

	/*
	  In: Body
	*/
	Payload models.LogEntry `json:"body,omitempty"`
}

// NewGetLogEntryByIndexOK creates GetLogEntryByIndexOK with default headers values
func NewGetLogEntryByIndexOK() *GetLogEntryByIndexOK {

	return &GetLogEntryByIndexOK{}
}

// WithPayload adds the payload to the get log entry by index o k response
func (o *GetLogEntryByIndexOK) WithPayload(payload models.LogEntry) *GetLogEntryByIndexOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log entry by index o k response
func (o *GetLogEntryByIndexOK) SetPayload(payload models.LogEntry) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogEntryByIndexOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty map
		payload = models.LogEntry{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetLogEntryByIndexNotFoundCode is the HTTP code returned for type GetLogEntryByIndexNotFound
const GetLogEntryByIndexNotFoundCode int = 404

/*
GetLogEntryByIndexNotFound The content requested could not be found

swagger:response getLogEntryByIndexNotFound
*/
type GetLogEntryByIndexNotFound struct {
}

// NewGetLogEntryByIndexNotFound creates GetLogEntryByIndexNotFound with default headers values
func NewGetLogEntryByIndexNotFound() *GetLogEntryByIndexNotFound {

	return &GetLogEntryByIndexNotFound{}
}

// WriteResponse to the client
func (o *GetLogEntryByIndexNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) // Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

/*
GetLogEntryByIndexDefault There was an internal error in the server while processing the request

swagger:response getLogEntryByIndexDefault
*/
type GetLogEntryByIndexDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogEntryByIndexDefault creates GetLogEntryByIndexDefault with default headers values
func NewGetLogEntryByIndexDefault(code int) *GetLogEntryByIndexDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogEntryByIndexDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log entry by index default response
func (o *GetLogEntryByIndexDefault) WithStatusCode(code int) *GetLogEntryByIndexDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log entry by index default response
func (o *GetLogEntryByIndexDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get log entry by index default response
func (o *GetLogEntryByIndexDefault) WithPayload(payload *models.Error) *GetLogEntryByIndexDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log entry by index default response
func (o *GetLogEntryByIndexDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogEntryByIndexDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
