# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DenySettingsMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """denySettings Mode that defines denied actions."""

    DENY_DELETE = "denyDelete"
    """Authorized users are able to read and modify the resources, but cannot delete."""
    DENY_WRITE_AND_DELETE = "denyWriteAndDelete"
    """Authorized users can read from a resource, but cannot modify or delete it."""
    NONE = "none"
    """No denyAssignments have been applied."""


class DenyStatusMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """denyAssignment settings applied to the resource."""

    DENY_DELETE = "denyDelete"
    """Authorized users are able to read and modify the resources, but cannot delete."""
    NOT_SUPPORTED = "notSupported"
    """Resource type does not support denyAssignments."""
    INAPPLICABLE = "inapplicable"
    """denyAssignments are not supported on resources outside the scope of the deployment stack."""
    DENY_WRITE_AND_DELETE = "denyWriteAndDelete"
    """Authorized users can only read from a resource, but cannot modify or delete it."""
    REMOVED_BY_SYSTEM = "removedBySystem"
    """Deny assignment has been removed by Azure due to a resource management change (management group
    move, etc.)"""
    NONE = "none"
    """No denyAssignments have been applied."""


class DeploymentStackProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the deployment stack."""

    CREATING = "creating"
    VALIDATING = "validating"
    WAITING = "waiting"
    DEPLOYING = "deploying"
    CANCELING = "canceling"
    UPDATING_DENY_ASSIGNMENTS = "updatingDenyAssignments"
    DELETING_RESOURCES = "deletingResources"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELED = "canceled"
    DELETING = "deleting"


class DeploymentStacksDeleteDetachEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies an action for a newly unmanaged resource. Delete will attempt to delete the resource
    from Azure. Detach will leave the resource in it's current state.
    """

    DELETE = "delete"
    DETACH = "detach"


class ResourceStatusMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current management state of the resource in the deployment stack."""

    MANAGED = "managed"
    """This resource is managed by the deployment stack."""
    REMOVE_DENY_FAILED = "removeDenyFailed"
    """Unable to remove the deny assignment on resource."""
    DELETE_FAILED = "deleteFailed"
    """Unable to delete the resource from Azure. The delete will be retried on the next stack
    deployment, or can be deleted manually."""


class UnmanageActionManagementGroupMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UnmanageActionManagementGroupMode."""

    DELETE = "delete"
    DETACH = "detach"


class UnmanageActionResourceGroupMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UnmanageActionResourceGroupMode."""

    DELETE = "delete"
    DETACH = "detach"


class UnmanageActionResourceMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """UnmanageActionResourceMode."""

    DELETE = "delete"
    DETACH = "detach"
