# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kusto import KustoManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKustoManagementDatabasesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KustoManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_check_name_availability(self, resource_group):
        response = self.client.databases.check_name_availability(
            resource_group_name=resource_group.name,
            cluster_name="str",
            resource_name={"name": "str", "type": "str"},
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_list_by_cluster(self, resource_group):
        response = self.client.databases.list_by_cluster(
            resource_group_name=resource_group.name,
            cluster_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_get(self, resource_group):
        response = self.client.databases.get(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_create_or_update(self, resource_group):
        response = self.client.databases.begin_create_or_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            parameters={
                "kind": "ReadOnlyFollowing",
                "attachedDatabaseConfigurationName": "str",
                "databaseShareOrigin": "str",
                "hotCachePeriod": "1 day, 0:00:00",
                "id": "str",
                "leaderClusterResourceId": "str",
                "location": "str",
                "name": "str",
                "originalDatabaseName": "str",
                "principalsModificationKind": "str",
                "provisioningState": "str",
                "softDeletePeriod": "1 day, 0:00:00",
                "statistics": {"size": 0.0},
                "suspensionDetails": {"suspensionStartDate": "2020-02-20 00:00:00"},
                "tableLevelSharingProperties": {
                    "externalTablesToExclude": ["str"],
                    "externalTablesToInclude": ["str"],
                    "functionsToExclude": ["str"],
                    "functionsToInclude": ["str"],
                    "materializedViewsToExclude": ["str"],
                    "materializedViewsToInclude": ["str"],
                    "tablesToExclude": ["str"],
                    "tablesToInclude": ["str"],
                },
                "type": "str",
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_update(self, resource_group):
        response = self.client.databases.begin_update(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            parameters={
                "kind": "ReadOnlyFollowing",
                "attachedDatabaseConfigurationName": "str",
                "databaseShareOrigin": "str",
                "hotCachePeriod": "1 day, 0:00:00",
                "id": "str",
                "leaderClusterResourceId": "str",
                "location": "str",
                "name": "str",
                "originalDatabaseName": "str",
                "principalsModificationKind": "str",
                "provisioningState": "str",
                "softDeletePeriod": "1 day, 0:00:00",
                "statistics": {"size": 0.0},
                "suspensionDetails": {"suspensionStartDate": "2020-02-20 00:00:00"},
                "tableLevelSharingProperties": {
                    "externalTablesToExclude": ["str"],
                    "externalTablesToInclude": ["str"],
                    "functionsToExclude": ["str"],
                    "functionsToInclude": ["str"],
                    "materializedViewsToExclude": ["str"],
                    "materializedViewsToInclude": ["str"],
                    "tablesToExclude": ["str"],
                    "tablesToInclude": ["str"],
                },
                "type": "str",
            },
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_delete(self, resource_group):
        response = self.client.databases.begin_delete(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            api_version="2024-04-13",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_list_principals(self, resource_group):
        response = self.client.databases.list_principals(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            api_version="2024-04-13",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_add_principals(self, resource_group):
        response = self.client.databases.add_principals(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            database_principals_to_add={
                "value": [
                    {
                        "name": "str",
                        "role": "str",
                        "type": "str",
                        "appId": "str",
                        "email": "str",
                        "fqn": "str",
                        "tenantName": "str",
                    }
                ]
            },
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_remove_principals(self, resource_group):
        response = self.client.databases.remove_principals(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            database_principals_to_remove={
                "value": [
                    {
                        "name": "str",
                        "role": "str",
                        "type": "str",
                        "appId": "str",
                        "email": "str",
                        "fqn": "str",
                        "tenantName": "str",
                    }
                ]
            },
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...
