# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._operations import (
    build_data_boundaries_get_scope_request,
    build_data_boundaries_get_tenant_request,
    build_data_boundaries_put_request,
)
from .._configuration import DataBoundaryMgmtClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DataBoundariesOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.resource.databoundaries.aio.DataBoundaryMgmtClient`'s
        :attr:`data_boundaries` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataBoundaryMgmtClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def put(
        self,
        default: Union[str, _models.DefaultName],
        data_boundary_definition: _models.DataBoundaryDefinition,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Opt-in tenant to data boundary.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.models.DefaultName
        :param data_boundary_definition: The data boundary to opt the tenant to. Required.
        :type data_boundary_definition:
         ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def put(
        self,
        default: Union[str, _models.DefaultName],
        data_boundary_definition: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Opt-in tenant to data boundary.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.models.DefaultName
        :param data_boundary_definition: The data boundary to opt the tenant to. Required.
        :type data_boundary_definition: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def put(
        self,
        default: Union[str, _models.DefaultName],
        data_boundary_definition: Union[_models.DataBoundaryDefinition, IO[bytes]],
        **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Opt-in tenant to data boundary.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.models.DefaultName
        :param data_boundary_definition: The data boundary to opt the tenant to. Is either a
         DataBoundaryDefinition type or a IO[bytes] type. Required.
        :type data_boundary_definition:
         ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition or IO[bytes]
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DataBoundaryDefinition] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(data_boundary_definition, (IOBase, bytes)):
            _content = data_boundary_definition
        else:
            _json = self._serialize.body(data_boundary_definition, "DataBoundaryDefinition")

        _request = build_data_boundaries_put_request(
            default=default,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DataBoundaryDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_tenant(
        self, default: Union[str, _models.DefaultName], **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Get data boundary of tenant.

        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.models.DefaultName
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DataBoundaryDefinition] = kwargs.pop("cls", None)

        _request = build_data_boundaries_get_tenant_request(
            default=default,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DataBoundaryDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_scope(
        self, scope: str, default: Union[str, _models.DefaultName], **kwargs: Any
    ) -> _models.DataBoundaryDefinition:
        """Get data boundary at specified scope.

        :param scope: The scope at which the operation is performed. Required.
        :type scope: str
        :param default: Default string modeled as parameter for auto generation to work correctly.
         "default" Required.
        :type default: str or ~azure.mgmt.resource.databoundaries.models.DefaultName
        :return: DataBoundaryDefinition or the result of cls(response)
        :rtype: ~azure.mgmt.resource.databoundaries.models.DataBoundaryDefinition
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.DataBoundaryDefinition] = kwargs.pop("cls", None)

        _request = build_data_boundaries_get_scope_request(
            scope=scope,
            default=default,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DataBoundaryDefinition", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
