// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file member_idCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__MEMBER_IDCDRAUX_IPP
#define FAST_DDS_GENERATED__MEMBER_IDCDRAUX_IPP

#include "member_idCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const FixId& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0000012c),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x000001f4),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x000001f5),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const FixId& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0000012c) << data.s()
        << eprosima::fastcdr::MemberId(0x000001f4) << data.l()
        << eprosima::fastcdr::MemberId(0x000001f5) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        FixId& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0000012c:
                                                dcdr >> data.s();
                                            break;

                                        case 0x000001f4:
                                                dcdr >> data.l();
                                            break;

                                        case 0x000001f5:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixId& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.o();

                        scdr << data.s();

                        scdr << data.l();

                        scdr << data.ll();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const FixHexId& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000100),
                data.ho(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000300),
                data.hs(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000500),
                data.hl(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000501),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const FixHexId& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00000100) << data.ho()
        << eprosima::fastcdr::MemberId(0x00000300) << data.hs()
        << eprosima::fastcdr::MemberId(0x00000500) << data.hl()
        << eprosima::fastcdr::MemberId(0x00000501) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        FixHexId& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00000100:
                                                dcdr >> data.ho();
                                            break;

                                        case 0x00000300:
                                                dcdr >> data.hs();
                                            break;

                                        case 0x00000500:
                                                dcdr >> data.hl();
                                            break;

                                        case 0x00000501:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixHexId& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.ho();

                        scdr << data.hs();

                        scdr << data.hl();

                        scdr << data.ll();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const FixHashidDefault& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x057956d9),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0e5eb92d),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0e5eb92e),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const FixHashidDefault& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x057956d9) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0e5eb92d) << data.l()
        << eprosima::fastcdr::MemberId(0x0e5eb92e) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        FixHashidDefault& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x057956d9:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0e5eb92d:
                                                dcdr >> data.l();
                                            break;

                                        case 0x0e5eb92e:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixHashidDefault& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.o();

                        scdr << data.s();

                        scdr << data.l();

                        scdr << data.ll();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const FixHashid& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x02b9e4e7),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x09da094f),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03645210),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const FixHashid& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x02b9e4e7) << data.o()
        << eprosima::fastcdr::MemberId(0x09da094f) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x03645210) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        FixHashid& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x02b9e4e7:
                                                dcdr >> data.o();
                                            break;

                                        case 0x09da094f:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x03645210:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixHashid& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.o();

                        scdr << data.l();

                        scdr << data.ll();

                        scdr << data.s();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const FixMix& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000200),
                data.ho(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03645210),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const FixMix& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x00000200) << data.ho()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x03645210) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        FixMix& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x00000200:
                                                dcdr >> data.ho();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x03645210:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const FixMix& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.o();

                        scdr << data.ho();

                        scdr << data.l();

                        scdr << data.ll();

                        scdr << data.s();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const AutoidDefault& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00088a4a),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00c0545b),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidDefault& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00088a4a) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x00c0545b) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        AutoidDefault& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00088a4a:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x00c0545b:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidDefault& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.o();

                        scdr << data.c();

                        scdr << data.ll();

                        scdr << data.l();

                        scdr << data.s();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const AutoidSequential& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000000),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03645210),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidSequential& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00000000) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x03645210) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        AutoidSequential& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00000000:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x03645210:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidSequential& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.c();

                        scdr << data.o();

                        scdr << data.l();

                        scdr << data.ll();

                        scdr << data.s();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const AutoidHash& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00088a4a),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00c0545b),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidHash& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00088a4a) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x00c0545b) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        AutoidHash& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00088a4a:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x00c0545b:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AutoidHash& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.o();

                        scdr << data.c();

                        scdr << data.ll();

                        scdr << data.l();

                        scdr << data.s();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const DerivedAutoidDefault& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00088a4a),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00c0545b),
                data.ll(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03ae6568),
                data.cd(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000065),
                data.od(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0bf72662),
                data.sd(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x07f89ae6),
                data.ld(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00e90b05),
                data.lld(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidDefault& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00088a4a) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x00c0545b) << data.ll()
        << eprosima::fastcdr::MemberId(0x03ae6568) << data.cd()
        << eprosima::fastcdr::MemberId(0x00000065) << data.od()
        << eprosima::fastcdr::MemberId(0x0bf72662) << data.sd()
        << eprosima::fastcdr::MemberId(0x07f89ae6) << data.ld()
        << eprosima::fastcdr::MemberId(0x00e90b05) << data.lld()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        DerivedAutoidDefault& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00088a4a:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x00c0545b:
                                                dcdr >> data.ll();
                                            break;

                                        case 0x03ae6568:
                                                dcdr >> data.cd();
                                            break;

                                        case 0x00000065:
                                                dcdr >> data.od();
                                            break;

                                        case 0x0bf72662:
                                                dcdr >> data.sd();
                                            break;

                                        case 0x07f89ae6:
                                                dcdr >> data.ld();
                                            break;

                                        case 0x00e90b05:
                                                dcdr >> data.lld();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidDefault& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const AutoidDefault& data);
    serialize_key(scdr, static_cast<const AutoidDefault&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const DerivedEmptyAutoidSequential& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000000),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03645210),
                data.ll(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedEmptyAutoidSequential& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00000000) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x03645210) << data.ll()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        DerivedEmptyAutoidSequential& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00000000:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x03645210:
                                                dcdr >> data.ll();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedEmptyAutoidSequential& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const AutoidSequential& data);
    serialize_key(scdr, static_cast<const AutoidSequential&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const DerivedAutoidSequential& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000000),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03645210),
                data.ll(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03645211),
                data.cd(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000065),
                data.od(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0bf72662),
                data.sd(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x07f89ae6),
                data.ld(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x07f89ae7),
                data.lld(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidSequential& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00000000) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x03645210) << data.ll()
        << eprosima::fastcdr::MemberId(0x03645211) << data.cd()
        << eprosima::fastcdr::MemberId(0x00000065) << data.od()
        << eprosima::fastcdr::MemberId(0x0bf72662) << data.sd()
        << eprosima::fastcdr::MemberId(0x07f89ae6) << data.ld()
        << eprosima::fastcdr::MemberId(0x07f89ae7) << data.lld()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        DerivedAutoidSequential& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00000000:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x03645210:
                                                dcdr >> data.ll();
                                            break;

                                        case 0x03645211:
                                                dcdr >> data.cd();
                                            break;

                                        case 0x00000065:
                                                dcdr >> data.od();
                                            break;

                                        case 0x0bf72662:
                                                dcdr >> data.sd();
                                            break;

                                        case 0x07f89ae6:
                                                dcdr >> data.ld();
                                            break;

                                        case 0x07f89ae7:
                                                dcdr >> data.lld();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidSequential& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const DerivedEmptyAutoidSequential& data);
    serialize_key(scdr, static_cast<const DerivedEmptyAutoidSequential&>(data));
}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const DerivedAutoidHash& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00088a4a),
                data.c(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000064),
                data.o(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0cc0c703),
                data.s(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0364520f),
                data.l(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00c0545b),
                data.ll(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x03ae6568),
                data.cd(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00000065),
                data.od(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x0bf72662),
                data.sd(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x07f89ae6),
                data.ld(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0x00e90b05),
                data.lld(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidHash& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0x00088a4a) << data.c()
        << eprosima::fastcdr::MemberId(0x00000064) << data.o()
        << eprosima::fastcdr::MemberId(0x0cc0c703) << data.s()
        << eprosima::fastcdr::MemberId(0x0364520f) << data.l()
        << eprosima::fastcdr::MemberId(0x00c0545b) << data.ll()
        << eprosima::fastcdr::MemberId(0x03ae6568) << data.cd()
        << eprosima::fastcdr::MemberId(0x00000065) << data.od()
        << eprosima::fastcdr::MemberId(0x0bf72662) << data.sd()
        << eprosima::fastcdr::MemberId(0x07f89ae6) << data.ld()
        << eprosima::fastcdr::MemberId(0x00e90b05) << data.lld()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        DerivedAutoidHash& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PL_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0x00088a4a:
                                                dcdr >> data.c();
                                            break;

                                        case 0x00000064:
                                                dcdr >> data.o();
                                            break;

                                        case 0x0cc0c703:
                                                dcdr >> data.s();
                                            break;

                                        case 0x0364520f:
                                                dcdr >> data.l();
                                            break;

                                        case 0x00c0545b:
                                                dcdr >> data.ll();
                                            break;

                                        case 0x03ae6568:
                                                dcdr >> data.cd();
                                            break;

                                        case 0x00000065:
                                                dcdr >> data.od();
                                            break;

                                        case 0x0bf72662:
                                                dcdr >> data.sd();
                                            break;

                                        case 0x07f89ae6:
                                                dcdr >> data.ld();
                                            break;

                                        case 0x00e90b05:
                                                dcdr >> data.lld();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const DerivedAutoidHash& data)
{
    extern void serialize_key(
            Cdr& scdr,
            const AutoidHash& data);
    serialize_key(scdr, static_cast<const AutoidHash&>(data));
}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__MEMBER_IDCDRAUX_IPP

