import { createIcon } from '@chakra-ui/icons';

const CalicoCatIcon = createIcon({
    displayName: 'CalicoCatIcon',
    viewBox: '0 0 35 35',
    path: (
        <>
            <path
                d='M25.5215 30.9209C24.7946 32.1714 21.5207 33.1145 17.5897 33.1145C13.6588 33.1145 10.3821 32.1714 9.65521 30.9209C8.71302 31.3126 8.16504 31.7796 8.16504 32.2798C8.16504 33.6719 12.3839 34.7988 17.5897 34.7988C22.7956 34.7988 27.0117 33.6719 27.0117 32.2798C27.0117 31.7796 26.4637 31.3126 25.5215 30.9209Z'
                fill='#B0B2B8'
            />
            <path
                d='M17.6035 33.1144C21.5344 33.1144 24.8083 32.1713 25.5352 30.9208C23.8577 30.2218 20.9333 29.7607 17.6035 29.7607C14.2737 29.7607 11.3436 30.2218 9.66895 30.9208C10.3819 32.1713 13.6558 33.1144 17.6035 33.1144Z'
                fill='#5F5F5F'
            />
            <path
                d='M24.2605 24.5179C24.7994 23.9798 25.3782 23.49 25.9911 23.0535C28.7534 21.0437 27.9957 17.8859 27.3275 15.3278C26.8494 13.5018 29.1392 13.0107 30.0199 18.2957C30.8866 23.4994 25.5466 27.5792 24.1123 27.5792'
                fill='white'
            />
            <path
                d='M24.1039 27.8445C24.0387 27.8445 23.9761 27.8166 23.93 27.7669C23.8838 27.7171 23.8579 27.6497 23.8579 27.5794C23.8579 27.509 23.8838 27.4416 23.93 27.3919C23.9761 27.3422 24.0387 27.3142 24.1039 27.3142C24.7833 27.3142 26.595 26.1963 28.0181 24.3764C29.0553 23.0386 30.2044 20.9053 29.7795 18.3501C29.3377 15.7136 28.5353 14.5536 27.9817 14.3577C27.9263 14.3315 27.8652 14.3227 27.8053 14.3323C27.7455 14.3419 27.6894 14.3695 27.6434 14.4119C27.5288 14.5325 27.4477 14.8187 27.5624 15.2616C28.211 17.7324 29.0973 21.1192 26.1281 23.2796C25.5326 23.7061 24.9715 24.1859 24.4506 24.7139C24.4039 24.763 24.341 24.7902 24.2757 24.7893C24.2104 24.7885 24.1481 24.7597 24.1025 24.7094C24.0569 24.659 24.0318 24.5912 24.0326 24.5209C24.0333 24.4505 24.06 24.3834 24.1067 24.3342C24.6507 23.7798 25.2371 23.2758 25.8597 22.8276C28.5353 20.8842 27.705 17.7053 27.0983 15.3912C26.9501 14.8247 27.0284 14.3125 27.3107 14.0202C27.4211 13.909 27.5583 13.8334 27.7065 13.802C27.8548 13.7706 28.0082 13.7846 28.1495 13.8425C29.0749 14.1679 29.8689 15.813 30.2743 18.2447C30.7356 21.0047 29.5138 23.2856 28.4067 24.7109C26.9333 26.5881 24.9986 27.8445 24.1039 27.8445Z'
                fill='#141414'
            />
            <path
                d='M25.5771 24.7077C25.5771 30.0952 21.9425 33.1144 17.4692 33.1144C12.9959 33.1144 9.36133 30.1013 9.36133 24.7077C9.36133 19.3142 12.9959 10.9136 17.4692 10.9136C21.9425 10.9136 25.5771 19.3172 25.5771 24.7077Z'
                fill='white'
            />
            <path
                d='M21.1039 23.3698C21.1039 25.9822 19.7479 28.2602 17.268 28.2602C14.7881 28.2602 13.4321 25.9822 13.4321 23.3698C13.4321 20.7574 14.7881 17.0422 17.268 17.0422C19.7479 17.0422 21.1039 20.7574 21.1039 23.3698Z'
                fill='#B0B2B8'
            />
            <path
                d='M24.61 7.74675C24.5792 8.18366 23.8216 7.61116 23.5616 7.92754L18.2495 4.43531C18.3954 4.03584 18.5732 3.65073 18.7807 3.28429C19.899 1.31369 22.3007 -0.687036 23.5029 0.75626C24.3388 1.74156 24.7917 5.19763 24.61 7.74675Z'
                fill='#F69320'
            />
            <path
                d='M23.6089 8.29244L23.4355 8.17794L17.9585 4.56217L18.034 4.35426C18.1879 3.93594 18.375 3.5327 18.5931 3.149C19.4599 1.62134 21.1094 0.000267051 22.5073 0.000267051C22.7364 -0.0041106 22.9636 0.0453791 23.1732 0.145291C23.3828 0.245202 23.5696 0.393135 23.7207 0.578791C24.6237 1.66352 25.0543 5.23711 24.8754 7.76514C24.8733 7.82415 24.8601 7.8821 24.8367 7.93548C24.8132 7.98886 24.78 8.03656 24.739 8.07571C24.698 8.11485 24.65 8.14463 24.598 8.16324C24.546 8.18184 24.491 8.18889 24.4364 8.18397C24.3271 8.17933 24.2185 8.16318 24.1121 8.13575C24.0203 8.11176 23.9268 8.09664 23.8325 8.09056C23.8096 8.08418 23.7855 8.08418 23.7626 8.09056L23.6089 8.29244ZM23.8157 7.58736C23.942 7.59149 24.0676 7.60966 24.1904 7.6416C24.2547 7.6416 24.319 7.66872 24.3693 7.67474C24.5427 5.05331 24.0422 1.80815 23.3349 0.958447C23.2311 0.828952 23.1022 0.725651 22.9572 0.655873C22.8123 0.586094 22.6548 0.551548 22.4961 0.554685C21.3442 0.554685 19.8205 2.0251 19.0125 3.4473C18.8483 3.73711 18.7035 4.0392 18.5792 4.35125L23.5585 7.63859C23.6398 7.60174 23.7276 7.58427 23.8157 7.58736V7.58736Z'
                fill='#141414'
            />
            <path
                d='M22.9295 6.0264C22.9295 6.17405 20.6929 4.76389 20.6929 4.76389C20.7414 4.63118 20.8003 4.50316 20.869 4.38123C21.2409 3.72737 22.0237 2.70592 22.4458 3.29951C22.7524 4.17143 22.916 5.09411 22.9295 6.0264Z'
                fill='#141414'
            />
            <path
                d='M22.9157 6.28834C22.8486 6.28834 22.6361 6.28834 20.5756 4.97763L20.3994 4.86313L20.4749 4.65221C20.5294 4.50513 20.5948 4.36304 20.6706 4.22735C20.8551 3.90193 21.5094 2.84131 22.1468 2.84131C22.246 2.84149 22.3437 2.86731 22.4318 2.91659C22.5198 2.96587 22.5956 3.03718 22.6528 3.12454C22.8318 3.37765 23.2456 5.18252 23.1841 6.03223C23.1784 6.10388 23.1473 6.17043 23.0974 6.21811C23.0474 6.26578 22.9823 6.29093 22.9157 6.28834ZM21.0145 4.64016C21.6519 5.0409 22.3201 5.44466 22.692 5.64052C22.6306 4.88835 22.4822 4.1474 22.2502 3.4349C22.2393 3.41514 22.2238 3.39887 22.2051 3.38775C22.1864 3.37663 22.1653 3.37106 22.144 3.37162C21.912 3.37162 21.4478 3.86879 21.0872 4.50456C21.0564 4.54976 21.0341 4.59496 21.0117 4.64016H21.0145Z'
                fill='#141414'
            />
            <path
                d='M10.22 7.92148C10.2508 8.35839 11.0112 7.7889 11.2685 8.10227L16.5805 4.61305C16.4351 4.21331 16.2574 3.82814 16.0493 3.46203C14.917 1.5065 12.5154 -0.509295 11.3132 0.934001C10.4912 1.9193 10.0383 5.37537 10.22 7.92148Z'
                fill='white'
            />
            <path
                d='M11.2236 8.43711L11.0839 8.27138C11.0607 8.26739 11.0371 8.26739 11.014 8.27138C10.9198 8.27654 10.8262 8.29065 10.7344 8.31357C10.629 8.34121 10.5213 8.35736 10.4129 8.36178V8.36178C10.3584 8.36714 10.3035 8.36049 10.2515 8.34223C10.1995 8.32397 10.1515 8.29449 10.1104 8.25558C10.0694 8.21667 10.0361 8.16915 10.0126 8.11592C9.98913 8.06269 9.97597 8.00486 9.97392 7.94596C9.79498 5.41794 10.2255 1.84435 11.1314 0.759616C11.2811 0.57268 11.4672 0.423638 11.6764 0.323117C11.8857 0.222596 12.1129 0.173073 12.342 0.178079C13.7175 0.178079 15.381 1.80819 16.2449 3.31476C16.463 3.69852 16.6501 4.10175 16.8041 4.52002L16.8796 4.72491L11.2236 8.43711ZM12.342 0.699353C12.1832 0.696216 12.0258 0.730762 11.8809 0.80054C11.7359 0.870319 11.607 0.97362 11.5032 1.10311C10.7959 1.95583 10.2954 5.20099 10.4688 7.82242L10.6477 7.78627C10.8554 7.72455 11.0747 7.72455 11.2824 7.78627L16.2589 4.52002C16.1352 4.20767 15.9904 3.90554 15.8256 3.61608C15.0204 2.17881 13.4966 0.70538 12.342 0.70538V0.699353Z'
                fill='#141414'
            />
            <path
                d='M11.8999 6.18907C11.8999 6.3337 14.1366 4.92657 14.1366 4.92657C14.0907 4.79415 14.0346 4.66614 13.9688 4.5439C13.597 3.88703 12.8141 2.86859 12.392 3.46218C12.0826 4.33355 11.9161 5.25625 11.8999 6.18907V6.18907Z'
                fill='#141414'
            />
            <path
                d='M11.9169 6.46322C11.8514 6.46502 11.7878 6.43984 11.7389 6.3928C11.6901 6.34577 11.6597 6.28044 11.6541 6.21012C11.5953 5.36041 12.0119 3.55554 12.1881 3.31449C12.2445 3.22699 12.3197 3.15553 12.4074 3.10621C12.495 3.05688 12.5924 3.03116 12.6913 3.03125C13.3315 3.03125 13.983 4.09188 14.1675 4.4173C14.2438 4.55266 14.3093 4.6948 14.3632 4.84215L14.4387 5.05006L14.2486 5.1525C12.1964 6.46021 11.984 6.46322 11.9169 6.46322ZM12.6913 3.5465C12.6689 3.5465 12.6298 3.5465 12.5767 3.62183C12.3499 4.33113 12.2053 5.06789 12.1461 5.81539C12.5124 5.61954 13.1806 5.21277 13.8236 4.81804C13.8026 4.77153 13.7793 4.72627 13.7537 4.68245C13.3875 4.04668 12.9234 3.5465 12.6913 3.5465V3.5465Z'
                fill='#141414'
            />
            <path
                d='M17.4805 33.3644C12.4955 33.3644 9.14893 29.8873 9.14893 24.7077C9.14893 19.1605 12.8813 10.6604 17.4805 10.6604C22.0796 10.6604 25.812 19.1605 25.812 24.7077C25.812 29.8873 22.4626 33.3644 17.4805 33.3644ZM17.4805 11.1636C16.3621 11.1636 14.1255 11.7813 11.9559 15.9123C10.5105 18.6482 9.61303 22.0169 9.61303 24.7077C9.61303 29.586 12.7751 32.8643 17.4805 32.8643C22.1858 32.8643 25.3451 29.586 25.3451 24.7077C25.3451 22.0169 24.4477 18.6482 23.005 15.9123C20.8215 11.7813 18.6072 11.1636 17.4805 11.1636Z'
                fill='#141414'
            />
            <path
                d='M23.5029 10.124C23.5097 9.56145 23.6399 9.00858 23.8829 8.51057C24.1258 8.01256 24.4746 7.58354 24.9008 7.25855C23.3127 5.26686 20.5784 3.94409 17.4723 3.94409H17.1591C17.411 5.10467 17.5164 6.29659 17.4723 7.48755C17.4723 12.2393 15.8703 16.2889 13.6196 17.8829C14.8546 18.3656 16.1586 18.6104 17.4723 18.606C21.4144 18.606 24.7554 16.4968 25.9184 13.553C24.5066 13.0227 23.5029 11.6849 23.5029 10.124Z'
                fill='white'
            />
            <path
                d='M17.4806 18.8804C16.1373 18.8876 14.8035 18.6377 13.5413 18.1422C13.4986 18.1257 13.4611 18.0966 13.4329 18.0582C13.4048 18.0199 13.3871 17.9738 13.382 17.9253C13.3778 17.8764 13.3856 17.8273 13.4048 17.7828C13.4239 17.7384 13.4537 17.7002 13.491 17.6721C15.7277 16.0902 17.2346 12.0014 17.2346 7.49978C17.2806 6.33117 17.178 5.16127 16.9299 4.02261C16.9206 3.98397 16.9196 3.94358 16.9269 3.90445C16.9341 3.86532 16.9495 3.82846 16.9718 3.79662C16.9944 3.76508 17.0231 3.73927 17.0559 3.72105C17.0888 3.70282 17.125 3.69262 17.1619 3.69116H17.2066H17.4862C20.5616 3.69116 23.4022 4.96271 25.102 7.093C25.1238 7.12065 25.14 7.15287 25.1496 7.18762C25.1593 7.22237 25.1621 7.25889 25.158 7.29488C25.1553 7.33142 25.1452 7.36687 25.1282 7.39866C25.1113 7.43045 25.088 7.45779 25.0601 7.47868C24.664 7.77712 24.3392 8.17247 24.1122 8.63232C23.8853 9.09218 23.7627 9.60344 23.7545 10.1242C23.7545 11.5374 24.6435 12.7909 26.0191 13.3151C26.0507 13.3276 26.0796 13.3468 26.1041 13.3717C26.1286 13.3966 26.1482 13.4265 26.1617 13.4598C26.1748 13.4926 26.1816 13.528 26.1816 13.5637C26.1816 13.5995 26.1748 13.6349 26.1617 13.6677C24.9175 16.7863 21.4311 18.8804 17.4806 18.8804ZM14.1536 17.8108C15.2303 18.174 16.3524 18.3569 17.4806 18.3531C21.1152 18.3531 24.3528 16.497 25.5885 13.7099C24.1571 13.056 23.2484 11.676 23.2484 10.1242C23.2546 9.56844 23.3746 9.02099 23.5998 8.52097C23.825 8.02094 24.1499 7.58067 24.5513 7.23161C22.9297 5.34236 20.3072 4.21846 17.4806 4.21846C17.6823 5.30104 17.7658 6.40533 17.7295 7.50882C17.7267 11.9833 16.3371 15.9486 14.1536 17.8108Z'
                fill='#141414'
            />
            <path
                d='M17.4807 7.49976C17.4818 6.31053 17.3769 5.12393 17.1676 3.9563C12.4147 4.09189 8.59277 7.31897 8.59277 11.2843C8.59277 14.195 10.6477 16.7079 13.6252 17.8951C15.8787 16.3011 17.3772 12.2485 17.4807 7.49976Z'
                fill='#F69320'
            />
            <path
                d='M13.628 18.1571C13.5994 18.1632 13.5699 18.1632 13.5413 18.1571C10.3848 16.9037 8.34668 14.2099 8.34668 11.2992C8.34668 7.18327 12.2189 3.84772 17.1619 3.7061C17.2197 3.70493 17.276 3.72573 17.321 3.76485C17.366 3.80397 17.3968 3.85891 17.4079 3.92003C17.6205 5.10454 17.7272 6.30827 17.7267 7.51472C17.6232 12.3357 16.0659 16.4999 13.7622 18.13C13.7208 18.1528 13.6742 18.1623 13.628 18.1571V18.1571ZM16.9662 4.21834C12.3894 4.43528 8.83595 7.50266 8.83595 11.2721C8.83595 13.9237 10.7008 16.3944 13.5888 17.5846C15.7053 15.9967 17.1311 12.0555 17.2234 7.48157C17.2284 6.38772 17.1423 5.2956 16.9662 4.21834V4.21834Z'
                fill='#141414'
            />
            <path
                d='M17.1675 3.9563C17.3768 5.12393 17.4817 6.31053 17.4806 7.49976C17.5247 6.3088 17.4194 5.11688 17.1675 3.9563V3.9563Z'
                fill='#F69320'
            />
            <path
                d='M17.4805 7.76489C17.4159 7.76334 17.3545 7.73481 17.3091 7.68533C17.2637 7.63585 17.2379 7.56931 17.2372 7.49974C17.2386 6.32774 17.1356 5.1583 16.9297 4.0075C16.921 3.94166 16.9356 3.8747 16.9706 3.81991C17.0056 3.76512 17.0584 3.72651 17.1186 3.71172C17.1787 3.69693 17.2419 3.70705 17.2954 3.74007C17.349 3.77309 17.3891 3.8266 17.4078 3.88999C17.6669 5.0739 17.7751 6.29036 17.7293 7.50576C17.7271 7.57531 17.6999 7.64122 17.6535 7.68957C17.6071 7.73792 17.545 7.76493 17.4805 7.76489V7.76489Z'
                fill='#141414'
            />
            <path
                d='M24.9091 7.25879C24.483 7.58378 24.1342 8.0128 23.8912 8.51081C23.6483 9.00882 23.5181 9.56169 23.5112 10.1243C23.5112 11.6851 24.5149 13.0229 25.9352 13.5653C26.2245 12.8452 26.3748 12.0691 26.3769 11.2843C26.3566 9.79511 25.835 8.36454 24.9091 7.25879V7.25879Z'
                fill='#F69320'
            />
            <path
                d='M26.0638 13.8967L25.8458 13.8153C24.2717 13.2127 23.2568 11.7634 23.2568 10.1242C23.2635 9.51892 23.4036 8.92402 23.6656 8.38859C23.9277 7.85316 24.3041 7.39255 24.7638 7.04478L24.9483 6.90015L25.0965 7.08696C26.0571 8.24197 26.5965 9.73327 26.6146 11.2843C26.6124 12.1042 26.4554 12.9151 26.1533 13.6677L26.0638 13.8967ZM24.8728 7.62631C24.5272 7.92817 24.2477 8.30862 24.0544 8.74043C23.8611 9.17225 23.7586 9.64477 23.7545 10.1242C23.7545 11.459 24.5485 12.6522 25.7982 13.2247C26.017 12.6049 26.1298 11.9474 26.1309 11.2843C26.1142 9.94534 25.6699 8.65352 24.8728 7.62631V7.62631Z'
                fill='#141414'
            />
            <path
                d='M15.1973 10.8474C16.3307 10.691 17.148 9.7104 17.0228 8.6573C16.8976 7.60421 15.8774 6.87735 14.744 7.03382C13.6107 7.19029 12.7934 8.17084 12.9185 9.22394C13.0437 10.277 14.064 11.0039 15.1973 10.8474Z'
                fill='#141414'
            />
            <path
                d='M15.2269 10.6108C16.0509 10.497 16.6451 9.78391 16.554 9.01802C16.463 8.25213 15.7212 7.72347 14.8972 7.83723C14.0732 7.95099 13.4791 8.66409 13.5701 9.42998C13.6611 10.1959 14.4029 10.7245 15.2269 10.6108Z'
                fill='white'
            />
            <path
                d='M15.1138 9.73405C15.4226 9.69035 15.6439 9.4172 15.6082 9.12395C15.5725 8.8307 15.2932 8.6284 14.9844 8.6721C14.6756 8.71579 14.4543 8.98895 14.49 9.2822C14.5257 9.57545 14.805 9.77775 15.1138 9.73405Z'
                fill='#141414'
            />
            <path
                d='M13.3653 7.5329C13.3459 7.53721 13.3259 7.53721 13.3066 7.5329L12.7474 7.29185C12.7072 7.2744 12.675 7.2406 12.6577 7.19774C12.6404 7.15489 12.6395 7.10643 12.6551 7.06285C12.6625 7.04125 12.6739 7.02147 12.6886 7.0047C12.7032 6.98793 12.7209 6.9745 12.7404 6.96523C12.76 6.95595 12.7811 6.95101 12.8024 6.9507C12.8238 6.95039 12.845 6.95471 12.8648 6.96342L13.424 7.20447C13.4532 7.22316 13.4763 7.25109 13.4902 7.28446C13.5041 7.31782 13.5081 7.355 13.5017 7.39091C13.4952 7.42682 13.4787 7.45973 13.4543 7.48514C13.4299 7.51055 13.3988 7.52723 13.3653 7.5329V7.5329Z'
                fill='#141414'
            />
            <path
                d='M13.8209 7.11697C13.7868 7.11658 13.7537 7.10502 13.7259 7.08383L13.0409 6.56557C13.0054 6.5383 12.9814 6.49702 12.974 6.45073C12.9667 6.40443 12.9767 6.35689 13.0017 6.31849C13.014 6.29965 13.0296 6.28361 13.0476 6.27129C13.0657 6.25897 13.0858 6.25061 13.1068 6.24669C13.1279 6.24277 13.1494 6.24337 13.1703 6.24845C13.1911 6.25353 13.2108 6.263 13.2282 6.2763L13.9132 6.79456C13.9491 6.82136 13.9737 6.86243 13.9816 6.90875C13.9894 6.95508 13.9799 7.00287 13.9551 7.04164C13.9396 7.06448 13.9195 7.08316 13.8962 7.09622C13.8729 7.10929 13.8472 7.11639 13.8209 7.11697V7.11697Z'
                fill='#141414'
            />
            <path
                d='M22.4178 9.2282C22.543 8.1751 21.7257 7.19454 20.5924 7.03807C19.459 6.8816 18.4387 7.60846 18.3136 8.66156C18.1884 9.71466 19.0057 10.6952 20.1391 10.8517C21.2724 11.0082 22.2927 10.2813 22.4178 9.2282Z'
                fill='#141414'
            />
            <path
                d='M21.7689 9.43316C21.8599 8.66727 21.2657 7.95417 20.4417 7.84041C19.6178 7.72665 18.876 8.2553 18.785 9.02119C18.6939 9.78708 19.2881 10.5002 20.1121 10.6139C20.9361 10.7277 21.6778 10.199 21.7689 9.43316Z'
                fill='white'
            />
            <path
                d='M20.8387 9.37541C20.8736 9.08159 20.651 8.80887 20.3416 8.76627C20.0322 8.72367 19.7532 8.92733 19.7183 9.22116C19.6835 9.51498 19.9061 9.78771 20.2155 9.8303C20.5249 9.8729 20.8039 9.66924 20.8387 9.37541Z'
                fill='#141414'
            />
            <path
                d='M21.9706 7.53295C21.9378 7.53232 21.9058 7.52146 21.8785 7.50168C21.8512 7.4819 21.8298 7.45405 21.8169 7.42147C21.8014 7.37751 21.8027 7.32873 21.8205 7.28581C21.8383 7.2429 21.8712 7.20933 21.9119 7.19247L22.4711 6.95142C22.5101 6.94034 22.5516 6.94508 22.5876 6.96474C22.6236 6.9844 22.6517 7.01761 22.6665 7.05809C22.6814 7.09857 22.6819 7.1435 22.668 7.18437C22.6542 7.22524 22.6269 7.25921 22.5913 7.27985L22.0322 7.5209C22.0127 7.52968 21.9917 7.53379 21.9706 7.53295V7.53295Z'
                fill='#141414'
            />
            <path
                d='M21.5176 7.11696C21.4827 7.11677 21.4488 7.10467 21.4207 7.0824C21.3926 7.06013 21.3718 7.02884 21.3613 6.99303C21.3507 6.95721 21.3509 6.91871 21.362 6.88305C21.373 6.84739 21.3942 6.81641 21.4226 6.79456L22.1075 6.2763C22.1446 6.24952 22.19 6.23972 22.2338 6.24905C22.2776 6.25837 22.3161 6.28606 22.341 6.32601C22.3658 6.36597 22.3749 6.41492 22.3663 6.46211C22.3576 6.50929 22.3319 6.55084 22.2949 6.57761L21.6099 7.09587C21.5817 7.11243 21.5496 7.11976 21.5176 7.11696V7.11696Z'
                fill='#141414'
            />
            <path
                d='M22.239 14.7313C22.239 16.3072 20.0974 17.5848 17.4581 17.5848C14.8188 17.5848 12.6772 16.3072 12.6772 14.7313C12.6772 13.1555 14.8188 12.1611 17.4581 12.1611C20.0974 12.1611 22.239 13.1555 22.239 14.7313Z'
                fill='white'
            />
            <path
                d='M17.542 16.7409C16.8516 16.7565 16.1704 16.5681 15.5721 16.1964C14.9738 15.8246 14.4813 15.2835 14.1479 14.6317C14.1321 14.6118 14.1206 14.5884 14.1144 14.563C14.1081 14.5377 14.1072 14.5112 14.1117 14.4854C14.1163 14.4597 14.1261 14.4354 14.1405 14.4143C14.155 14.3932 14.1736 14.3759 14.1951 14.3636C14.2166 14.3513 14.2404 14.3444 14.2647 14.3434C14.289 14.3424 14.3132 14.3472 14.3355 14.3576C14.3578 14.3681 14.3776 14.3837 14.3936 14.4035C14.4095 14.4233 14.4211 14.4468 14.4275 14.472C14.7345 15.0645 15.1858 15.5553 15.7327 15.8914C16.2797 16.2276 16.9014 16.3963 17.5308 16.3794H17.5756C18.1911 16.385 18.7971 16.2145 19.3315 15.8853C19.8659 15.556 20.3097 15.0797 20.6174 14.5052C20.6272 14.4844 20.6407 14.466 20.6571 14.4509C20.6735 14.4359 20.6926 14.4245 20.7132 14.4175C20.7337 14.4105 20.7554 14.408 20.7769 14.4101C20.7984 14.4122 20.8193 14.4189 20.8383 14.4299C20.8762 14.4522 20.9044 14.4896 20.9169 14.5341C20.9295 14.5786 20.9253 14.6266 20.9054 14.6679C20.578 15.3007 20.0988 15.8271 19.5179 16.1918C18.937 16.5565 18.2758 16.7462 17.6035 16.7409H17.542Z'
                fill='#141414'
            />
            <path
                d='M17.4583 17.847C14.6401 17.847 12.4258 16.479 12.4258 14.7314C12.4258 13.0621 14.4947 11.896 17.4583 11.896C20.4218 11.896 22.4907 13.0621 22.4907 14.7314C22.4851 16.479 20.2764 17.847 17.4583 17.847ZM17.4583 12.4233C14.8302 12.4233 12.9234 13.3935 12.9234 14.7284C12.9234 16.1295 15.0007 17.3166 17.4583 17.3166C19.9158 17.3166 21.9931 16.1295 21.9931 14.7284C21.9931 13.3965 20.0863 12.4263 17.4583 12.4263V12.4233Z'
                fill='#141414'
            />
            <path
                d='M17.7239 13.2368H17.3408V16.6537H17.7239V13.2368Z'
                fill='#141414'
            />
            <path
                d='M18.9345 12.3329C18.9345 13.1676 17.5366 13.6798 17.5366 13.6798C17.5366 13.6798 16.1387 13.1676 16.1387 12.3329C16.1387 11.4983 16.7649 11.5947 17.5366 11.5947C18.3082 11.5947 18.9345 11.4983 18.9345 12.3329Z'
                fill='#141414'
            />
            <path
                d='M22.27 29.7609C22.27 30.5021 21.9597 33.6569 20.2011 33.4249C19.2533 33.2983 17.9057 31.7013 18.4733 31.2855C19.0408 30.8697 17.8694 28.5737 18.683 29.1522C19.4966 29.7307 22.27 29.0196 22.27 29.7609Z'
                fill='white'
            />
            <path
                d='M21.3274 32.542C21.3274 33.2833 20.6788 33.5454 19.6499 33.5454C18.6211 33.5454 17.8047 32.9428 17.8047 32.2046C17.8047 31.4663 18.266 30.8456 19.1327 31.4212C19.9994 31.9967 21.3274 31.8129 21.3274 32.542Z'
                fill='white'
            />
            <path
                d='M19.5609 32.8432C18.9335 32.6008 18.3616 32.2166 17.8834 31.7163C17.838 31.8349 17.8143 31.9617 17.8135 32.0899C17.8135 32.9005 18.7081 33.5573 19.8069 33.5573C20.2843 33.5653 20.7541 33.4286 21.1629 33.1626C20.6158 33.1563 20.0738 33.0483 19.5609 32.8432Z'
                fill='white'
            />
            <path
                d='M19.8093 33.7773C18.5987 33.7773 17.6118 33.021 17.6118 32.0899C17.6118 31.4873 18.0032 30.963 18.6435 30.6557C18.5483 30.1596 18.4931 29.6555 18.4785 29.1491C18.4774 29.1202 18.4816 29.0914 18.4908 29.0642C18.5 29.0371 18.5141 29.0121 18.5323 28.9909C18.5505 28.9696 18.5724 28.9524 18.5967 28.9403C18.6211 28.9281 18.6474 28.9213 18.6742 28.9201C18.7286 28.9185 18.7814 28.94 18.8212 28.9801C18.861 29.0201 18.8845 29.0754 18.8867 29.134C18.9034 29.6728 18.968 30.2086 19.0796 30.734L19.1216 30.9238L18.951 30.9901C18.3919 31.2131 18.0228 31.6319 18.0228 32.0809C18.0228 32.7679 18.8252 33.3283 19.8093 33.3283C20.5978 33.3283 21.3023 32.9577 21.5288 32.4244C21.9414 31.351 22.2287 30.2265 22.3843 29.0768C22.3881 29.0481 22.3972 29.0205 22.4109 28.9956C22.4247 28.9707 22.4429 28.9489 22.4644 28.9316C22.486 28.9142 22.5105 28.9016 22.5365 28.8945C22.5626 28.8874 22.5897 28.8858 22.6163 28.89C22.643 28.8941 22.6686 28.9039 22.6917 28.9187C22.7148 28.9335 22.735 28.9531 22.7511 28.9763C22.7672 28.9996 22.7789 29.026 22.7855 29.0541C22.7921 29.0822 22.7935 29.1114 22.7897 29.1401C22.6287 30.3322 22.331 31.4982 21.9034 32.6112C21.607 33.3133 20.7683 33.7773 19.8093 33.7773Z'
                fill='#141414'
            />
            <path
                d='M12.5518 29.7609C12.5518 30.5021 12.8649 33.6569 14.6207 33.4249C15.5684 33.2983 16.9188 31.7013 16.3485 31.2855C15.7781 30.8697 16.7203 28.5737 15.9067 29.1522C15.0932 29.7307 12.5518 29.0196 12.5518 29.7609Z'
                fill='white'
            />
            <path
                d='M13.4937 32.542C13.4937 33.2833 14.1423 33.5454 15.1711 33.5454C16.2 33.5454 17.0136 32.9428 17.0136 32.2046C17.0136 31.4663 16.5551 30.8456 15.6884 31.4212C14.8217 31.9967 13.4937 31.8129 13.4937 32.542Z'
                fill='white'
            />
            <path
                d='M15.448 32.9217C16.0592 32.6403 16.6081 32.2223 17.0584 31.6953C17.1093 31.8105 17.1388 31.9354 17.145 32.0629C17.1842 32.8735 16.3231 33.5695 15.2243 33.6388C14.748 33.6732 14.2723 33.5626 13.8516 33.3194C14.4009 33.2864 14.9409 33.1519 15.448 32.9217Z'
                fill='white'
            />
            <path
                d='M15.012 33.7774C14.0558 33.7774 13.2143 33.3134 12.9235 32.6173C12.4922 31.5031 12.1926 30.3349 12.0316 29.1402C12.0244 29.0823 12.0385 29.0237 12.0709 28.977C12.1033 28.9302 12.1515 28.899 12.205 28.8901C12.2316 28.8858 12.2588 28.8873 12.2849 28.8944C12.311 28.9015 12.3355 28.9141 12.3571 28.9314C12.3787 28.9488 12.3968 28.9706 12.4105 28.9956C12.4243 29.0205 12.4333 29.0482 12.437 29.0769C12.5922 30.2332 12.8815 31.364 13.2981 32.4426C13.519 32.9669 14.2264 33.3465 15.012 33.3465C15.9989 33.3465 16.8013 32.7861 16.8013 32.0991C16.8013 31.6501 16.4462 31.2313 15.8731 31.0083L15.7025 30.942L15.7417 30.7492C15.8562 30.2253 15.9208 29.6902 15.9346 29.1522C15.9382 29.0941 15.9621 29.0397 16.0016 28.9999C16.041 28.9602 16.0931 28.9382 16.1471 28.9383C16.2015 28.9406 16.2528 28.966 16.29 29.0089C16.3271 29.0517 16.3471 29.1087 16.3456 29.1673C16.331 29.6737 16.2758 30.1777 16.1806 30.6739C16.8209 30.9752 17.2095 31.5175 17.2095 32.1081C17.2095 33.0211 16.2254 33.7774 15.012 33.7774Z'
                fill='#141414'
            />
            <path
                d='M19.7762 14.3125C19.9075 14.3125 20.0139 14.1979 20.0139 14.0564C20.0139 13.915 19.9075 13.8003 19.7762 13.8003C19.645 13.8003 19.5386 13.915 19.5386 14.0564C19.5386 14.1979 19.645 14.3125 19.7762 14.3125Z'
                fill='#141414'
            />
            <path
                d='M15.3504 14.3125C15.4817 14.3125 15.5881 14.1979 15.5881 14.0564C15.5881 13.915 15.4817 13.8003 15.3504 13.8003C15.2192 13.8003 15.1128 13.915 15.1128 14.0564C15.1128 14.1979 15.2192 14.3125 15.3504 14.3125Z'
                fill='#141414'
            />
            <path
                d='M23.9698 14.002L20.5673 13.9598C20.5235 13.9598 20.4816 13.9411 20.4507 13.9077C20.4197 13.8744 20.4023 13.8292 20.4023 13.782C20.4023 13.7349 20.4197 13.6897 20.4507 13.6563C20.4816 13.623 20.5235 13.6042 20.5673 13.6042L23.967 13.6494C24.0067 13.6551 24.0432 13.676 24.0696 13.7085C24.096 13.7409 24.1105 13.7826 24.1105 13.8257C24.1105 13.8689 24.096 13.9105 24.0696 13.943C24.0432 13.9754 24.0067 13.9964 23.967 14.002H23.9698Z'
                fill='#141414'
            />
            <path
                d='M20.1001 13.3151C20.0627 13.3139 20.0267 13.299 19.9982 13.2729C19.9696 13.2468 19.9501 13.211 19.943 13.1713C19.9358 13.1317 19.9414 13.0907 19.9588 13.0549C19.9761 13.0191 20.0043 12.9908 20.0386 12.9746L23.2398 11.6187C23.2603 11.6068 23.283 11.5997 23.3062 11.5979C23.3295 11.5961 23.3528 11.5996 23.3747 11.6082C23.3966 11.6168 23.4165 11.6304 23.4332 11.6479C23.4499 11.6654 23.4629 11.6866 23.4715 11.7099C23.48 11.7333 23.4839 11.7584 23.4828 11.7835C23.4817 11.8085 23.4757 11.8331 23.4652 11.8555C23.4547 11.8779 23.4398 11.8977 23.4217 11.9135C23.4036 11.9292 23.3826 11.9407 23.36 11.9471L20.1588 13.303C20.1402 13.3114 20.1202 13.3155 20.1001 13.3151V13.3151Z'
                fill='#141414'
            />
            <path
                d='M11.2041 14.002C11.1644 13.9964 11.1279 13.9754 11.1015 13.943C11.0751 13.9105 11.0605 13.8689 11.0605 13.8257C11.0605 13.7826 11.0751 13.7409 11.1015 13.7085C11.1279 13.676 11.1644 13.6551 11.2041 13.6494L14.6038 13.6042C14.6475 13.6042 14.6895 13.623 14.7204 13.6563C14.7514 13.6897 14.7687 13.7349 14.7687 13.782C14.7687 13.8292 14.7514 13.8744 14.7204 13.9077C14.6895 13.9411 14.6475 13.9598 14.6038 13.9598L11.2013 14.002H11.2041Z'
                fill='#141414'
            />
            <path
                d='M15.0875 13.315C15.0681 13.3193 15.0481 13.3193 15.0288 13.315L11.8275 11.9591C11.805 11.9527 11.784 11.9412 11.7659 11.9254C11.7477 11.9096 11.7329 11.8899 11.7224 11.8675C11.7119 11.8451 11.7059 11.8205 11.7048 11.7954C11.7037 11.7703 11.7075 11.7453 11.7161 11.7219C11.7247 11.6985 11.7377 11.6774 11.7544 11.6599C11.7711 11.6423 11.791 11.6288 11.8129 11.6202C11.8348 11.6116 11.8581 11.608 11.8814 11.6098C11.9046 11.6116 11.9272 11.6187 11.9478 11.6306L15.149 12.9865C15.1782 13.0054 15.2013 13.0336 15.215 13.0672C15.2288 13.1008 15.2326 13.1382 15.2258 13.1742C15.2191 13.2102 15.2022 13.243 15.1774 13.2682C15.1526 13.2935 15.1212 13.3098 15.0875 13.315V13.315Z'
                fill='#141414'
            />
        </>
    ),
});

export default CalicoCatIcon;
